/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import java.io.Closeable;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.NoMergePolicy;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.BufferedChecksum;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.store.ByteArrayIndexInput;
import org.elasticsearch.common.lucene.store.InputStreamIndexInput;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRefCounted;
import org.elasticsearch.common.util.concurrent.RefCounted;
import org.elasticsearch.common.util.iterable.Iterables;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.env.ShardLock;
import org.elasticsearch.env.ShardLockObtainFailedException;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.engine.CombinedDeletionPolicy;
import org.elasticsearch.index.seqno.SequenceNumbers;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.ByteSizeCachingDirectory;
import org.elasticsearch.index.store.StoreFileMetaData;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.index.store.VerifyingIndexOutput;

public class Store
extends AbstractIndexShardComponent
implements Closeable,
RefCounted {
    static final String CODEC = "store";
    static final int VERSION_WRITE_THROWABLE = 2;
    static final int VERSION_STACK_TRACE = 1;
    static final int VERSION_START = 0;
    static final int VERSION = 2;
    public static final String CORRUPTED = "corrupted_";
    public static final Setting<TimeValue> INDEX_STORE_STATS_REFRESH_INTERVAL_SETTING = Setting.timeSetting("index.store.stats_refresh_interval", TimeValue.timeValueSeconds((long)10L), Setting.Property.IndexScope);
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final StoreDirectory directory;
    private final ReentrantReadWriteLock metadataLock = new ReentrantReadWriteLock();
    private final ShardLock shardLock;
    private final OnClose onClose;
    private final AbstractRefCounted refCounter = new AbstractRefCounted("store"){

        @Override
        protected void closeInternal() {
            Store.this.closeInternal();
        }
    };

    public Store(ShardId shardId, IndexSettings indexSettings, Directory directory, ShardLock shardLock) {
        this(shardId, indexSettings, directory, shardLock, OnClose.EMPTY);
    }

    public Store(ShardId shardId, IndexSettings indexSettings, Directory directory, ShardLock shardLock, OnClose onClose) {
        super(shardId, indexSettings);
        TimeValue refreshInterval = indexSettings.getValue(INDEX_STORE_STATS_REFRESH_INTERVAL_SETTING);
        this.logger.debug("store stats are refreshed with refresh_interval [{}]", (Object)refreshInterval);
        ByteSizeCachingDirectory sizeCachingDir = new ByteSizeCachingDirectory(directory, refreshInterval);
        this.directory = new StoreDirectory(sizeCachingDir, Loggers.getLogger("index.store.deletes", shardId));
        this.shardLock = shardLock;
        this.onClose = onClose;
        assert (onClose != null);
        assert (shardLock != null);
        assert (shardLock.getShardId().equals(shardId));
    }

    public Directory directory() {
        this.ensureOpen();
        return this.directory;
    }

    public SegmentInfos readLastCommittedSegmentsInfo() throws IOException {
        this.failIfCorrupted();
        try {
            return Store.readSegmentsInfo(null, this.directory());
        }
        catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
            this.markStoreCorrupted((IOException)ex);
            throw ex;
        }
    }

    private static SegmentInfos readSegmentsInfo(IndexCommit commit, Directory directory) throws IOException {
        assert (commit == null || commit.getDirectory() == directory);
        try {
            return commit == null ? Lucene.readSegmentInfos(directory) : Lucene.readSegmentInfos(commit);
        }
        catch (EOFException eof) {
            throw new CorruptIndexException("Read past EOF while reading segment infos", "commit(" + commit + ")", (Throwable)eof);
        }
        catch (IOException exception) {
            throw exception;
        }
        catch (Exception ex) {
            throw new CorruptIndexException("Hit unexpected exception while reading segment infos", "commit(" + commit + ")", (Throwable)ex);
        }
    }

    public static SequenceNumbers.CommitInfo loadSeqNoInfo(IndexCommit commit) throws IOException {
        Map userData = commit.getUserData();
        return SequenceNumbers.loadSeqNoInfoFromLuceneCommit(userData.entrySet());
    }

    final void ensureOpen() {
        if (this.refCounter.refCount() <= 0) {
            throw new AlreadyClosedException("store is already closed");
        }
    }

    public MetadataSnapshot getMetadata(IndexCommit commit) throws IOException {
        return this.getMetadata(commit, false);
    }

    public MetadataSnapshot getMetadata(IndexCommit commit, boolean lockDirectory) throws IOException {
        this.ensureOpen();
        this.failIfCorrupted();
        assert (!lockDirectory || commit == null) : "IW lock should not be obtained if there is a commit point available";
        java.util.concurrent.locks.Lock lock = lockDirectory ? this.metadataLock.writeLock() : this.metadataLock.readLock();
        lock.lock();
        try {
            MetadataSnapshot metadataSnapshot;
            block12: {
                Closeable ignored = lockDirectory ? this.directory.obtainLock("write.lock") : () -> {};
                try {
                    metadataSnapshot = new MetadataSnapshot(commit, (Directory)this.directory, this.logger);
                    if (ignored == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
                        this.markStoreCorrupted((IOException)ex);
                        throw ex;
                    }
                }
                ignored.close();
            }
            return metadataSnapshot;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameTempFilesSafe(Map<String, String> tempFileMap) throws IOException {
        Object[] entries = tempFileMap.entrySet().toArray(new Map.Entry[0]);
        ArrayUtil.timSort((Object[])entries, (o1, o2) -> {
            String left = (String)o1.getValue();
            String right = (String)o2.getValue();
            if (left.startsWith("segments") || right.startsWith("segments")) {
                if (!left.startsWith("segments")) {
                    return -1;
                }
                if (!right.startsWith("segments")) {
                    return 1;
                }
            }
            return left.compareTo(right);
        });
        this.metadataLock.writeLock().lock();
        try (Lock writeLock = this.directory().obtainLock("write.lock");){
            for (Object entry : entries) {
                String tempFile = (String)entry.getKey();
                String origFile = (String)entry.getValue();
                try {
                    this.directory.deleteFile(origFile);
                }
                catch (FileNotFoundException | NoSuchFileException iOException) {
                }
                catch (Exception ex) {
                    this.logger.debug(() -> new ParameterizedMessage("failed to delete file [{}]", (Object)origFile), (Throwable)ex);
                }
                this.directory.rename(tempFile, origFile);
                String remove = tempFileMap.remove(tempFile);
                assert (remove != null);
            }
            this.directory.syncMetaData();
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    public CheckIndex.Status checkIndex(PrintStream out) throws IOException {
        this.metadataLock.writeLock().lock();
        try {
            CheckIndex.Status status;
            try (CheckIndex checkIndex = new CheckIndex((Directory)this.directory);){
                checkIndex.setInfoStream(out);
                status = checkIndex.checkIndex();
            }
            return status;
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    public StoreStats stats() throws IOException {
        this.ensureOpen();
        return new StoreStats(this.directory.estimateSize());
    }

    @Override
    public final void incRef() {
        this.refCounter.incRef();
    }

    @Override
    public final boolean tryIncRef() {
        return this.refCounter.tryIncRef();
    }

    @Override
    public final void decRef() {
        this.refCounter.decRef();
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.decRef();
            this.logger.debug("store reference count on close: {}", (Object)this.refCounter.refCount());
        }
    }

    private void closeInternal() {
        try {
            try {
                this.directory.innerClose();
            }
            finally {
                this.onClose.accept(this.shardLock);
            }
        }
        catch (IOException e) {
            try {
                this.logger.debug("failed to close directory", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.shardLock});
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.shardLock});
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.shardLock});
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static MetadataSnapshot readMetadataSnapshot(Path indexLocation, ShardId shardId, NodeEnvironment.ShardLocker shardLocker, Logger logger) throws IOException {
        try (ShardLock lock2 = shardLocker.lock(shardId, TimeUnit.SECONDS.toMillis(5L));){
            MetadataSnapshot metadataSnapshot;
            try (SimpleFSDirectory dir = new SimpleFSDirectory(indexLocation);){
                Store.failIfCorrupted((Directory)dir, shardId);
                metadataSnapshot = new MetadataSnapshot(null, (Directory)dir, logger);
            }
            return metadataSnapshot;
        }
        catch (IndexNotFoundException lock2) {
        }
        catch (FileNotFoundException | NoSuchFileException ex) {
            logger.info("Failed to open / find files while reading metadata snapshot");
        }
        catch (ShardLockObtainFailedException ex) {
            logger.info(() -> new ParameterizedMessage("{}: failed to obtain shard lock", (Object)shardId), (Throwable)ex);
        }
        return MetadataSnapshot.EMPTY;
    }

    public static void tryOpenIndex(Path indexLocation, ShardId shardId, NodeEnvironment.ShardLocker shardLocker, Logger logger) throws IOException, ShardLockObtainFailedException {
        try (ShardLock lock = shardLocker.lock(shardId, TimeUnit.SECONDS.toMillis(5L));
             SimpleFSDirectory dir = new SimpleFSDirectory(indexLocation);){
            Store.failIfCorrupted((Directory)dir, shardId);
            SegmentInfos segInfo = Lucene.readSegmentInfos((Directory)dir);
            logger.trace("{} loaded segment info [{}]", (Object)shardId, (Object)segInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IndexOutput createVerifyingOutput(String fileName, StoreFileMetaData metadata, IOContext context) throws IOException {
        IndexOutput output = this.directory().createOutput(fileName, context);
        boolean success = false;
        try {
            if ($assertionsDisabled) return new LuceneVerifyingIndexOutput(metadata, output);
            if (metadata.writtenBy() != null) return new LuceneVerifyingIndexOutput(metadata, output);
            throw new AssertionError();
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{output});
            throw throwable;
        }
    }

    public static void verify(IndexOutput output) throws IOException {
        if (output instanceof VerifyingIndexOutput) {
            ((VerifyingIndexOutput)output).verify();
        }
    }

    public IndexInput openVerifyingInput(String filename, IOContext context, StoreFileMetaData metadata) throws IOException {
        assert (metadata.writtenBy() != null);
        return new VerifyingIndexInput(this.directory().openInput(filename, context));
    }

    public static void verify(IndexInput input) throws IOException {
        if (input instanceof VerifyingIndexInput) {
            ((VerifyingIndexInput)input).verify();
        }
    }

    public boolean checkIntegrityNoException(StoreFileMetaData md) {
        return Store.checkIntegrityNoException(md, this.directory());
    }

    public static boolean checkIntegrityNoException(StoreFileMetaData md, Directory directory) {
        try {
            Store.checkIntegrity(md, directory);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void checkIntegrity(StoreFileMetaData md, Directory directory) throws IOException {
        try (IndexInput input = directory.openInput(md.name(), IOContext.READONCE);){
            if (input.length() != md.length()) {
                throw new CorruptIndexException("expected length=" + md.length() + " != actual length: " + input.length() + " : file truncated?", (DataInput)input);
            }
            String checksum = Store.digestToString(CodecUtil.checksumEntireFile((IndexInput)input));
            if (!checksum.equals(md.checksum())) {
                throw new CorruptIndexException("inconsistent metadata: lucene checksum=" + checksum + ", metadata checksum=" + md.checksum(), (DataInput)input);
            }
        }
    }

    public boolean isMarkedCorrupted() throws IOException {
        String[] files;
        this.ensureOpen();
        for (String file : files = this.directory().listAll()) {
            if (!file.startsWith(CORRUPTED)) continue;
            return true;
        }
        return false;
    }

    public void removeCorruptionMarker() throws IOException {
        String[] files;
        this.ensureOpen();
        Directory directory = this.directory();
        IOException firstException = null;
        for (String file : files = directory.listAll()) {
            if (!file.startsWith(CORRUPTED)) continue;
            try {
                directory.deleteFile(file);
            }
            catch (IOException ex) {
                if (firstException == null) {
                    firstException = ex;
                    continue;
                }
                firstException.addSuppressed(ex);
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public void failIfCorrupted() throws IOException {
        this.ensureOpen();
        Store.failIfCorrupted((Directory)this.directory, this.shardId);
    }

    private static void failIfCorrupted(Directory directory, ShardId shardId) throws IOException {
        String[] files = directory.listAll();
        ArrayList<CorruptIndexException> ex = new ArrayList<CorruptIndexException>();
        for (String file : files) {
            if (!file.startsWith(CORRUPTED)) continue;
            try (ChecksumIndexInput input = directory.openChecksumInput(file, IOContext.READONCE);){
                int version = CodecUtil.checkHeader((DataInput)input, (String)CODEC, (int)0, (int)2);
                if (version == 2) {
                    int size = input.readVInt();
                    byte[] buffer = new byte[size];
                    input.readBytes(buffer, 0, buffer.length);
                    StreamInput in = StreamInput.wrap(buffer);
                    Object t = in.readException();
                    if (t instanceof CorruptIndexException) {
                        ex.add((CorruptIndexException)((Object)t));
                    } else {
                        ex.add(new CorruptIndexException(((Throwable)t).getMessage(), "preexisting_corruption", t));
                    }
                } else {
                    assert (version == 0 || version == 1);
                    String msg = input.readString();
                    StringBuilder builder = new StringBuilder(shardId.toString());
                    builder.append(" Preexisting corrupted index [");
                    builder.append(file).append("] caused by: ");
                    builder.append(msg);
                    if (version == 1) {
                        builder.append(System.lineSeparator());
                        builder.append(input.readString());
                    }
                    ex.add(new CorruptIndexException(builder.toString(), "preexisting_corruption"));
                }
                CodecUtil.checkFooter((ChecksumIndexInput)input);
            }
        }
        if (!ex.isEmpty()) {
            ExceptionsHelper.rethrowAndSuppress(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupAndVerify(String reason, MetadataSnapshot sourceMetaData) throws IOException {
        this.metadataLock.writeLock().lock();
        try (Lock writeLock = this.directory.obtainLock("write.lock");){
            for (String existingFile : this.directory.listAll()) {
                if (Store.isAutogenerated(existingFile) || sourceMetaData.contains(existingFile)) continue;
                try {
                    this.directory.deleteFile(reason, existingFile);
                }
                catch (IOException ex) {
                    if (existingFile.startsWith("segments") || existingFile.equals("segments.gen") || existingFile.startsWith(CORRUPTED)) {
                        throw new IllegalStateException("Can't delete " + existingFile + " - cleanup failed", ex);
                    }
                    this.logger.debug(() -> new ParameterizedMessage("failed to delete file [{}]", (Object)existingFile), (Throwable)ex);
                }
            }
            this.directory.syncMetaData();
            MetadataSnapshot metadataOrEmpty = this.getMetadata(null);
            this.verifyAfterCleanup(sourceMetaData, metadataOrEmpty);
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    final void verifyAfterCleanup(MetadataSnapshot sourceMetaData, MetadataSnapshot targetMetaData) {
        RecoveryDiff recoveryDiff = targetMetaData.recoveryDiff(sourceMetaData);
        if (recoveryDiff.identical.size() != recoveryDiff.size()) {
            if (recoveryDiff.missing.isEmpty()) {
                for (StoreFileMetaData meta : recoveryDiff.different) {
                    StoreFileMetaData remote;
                    StoreFileMetaData local = targetMetaData.get(meta.name());
                    if (local.isSame(remote = sourceMetaData.get(meta.name()))) continue;
                    this.logger.debug("Files are different on the recovery target: {} ", (Object)recoveryDiff);
                    throw new IllegalStateException("local version: " + local + " is different from remote version after recovery: " + remote, null);
                }
            } else {
                this.logger.debug("Files are missing on the recovery target: {} ", (Object)recoveryDiff);
                throw new IllegalStateException("Files are missing on the recovery target: [different=" + recoveryDiff.different + ", missing=" + recoveryDiff.missing + ']', null);
            }
        }
    }

    public int refCount() {
        return this.refCounter.refCount();
    }

    public static boolean isAutogenerated(String name) {
        return "write.lock".equals(name);
    }

    public static String digestToString(long digest) {
        return Long.toString(digest, 36);
    }

    public void deleteQuiet(String ... files) {
        this.ensureOpen();
        StoreDirectory directory = this.directory;
        for (String file : files) {
            try {
                directory.deleteFile("Store.deleteQuiet", file);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void markStoreCorrupted(IOException exception) throws IOException {
        this.ensureOpen();
        if (!this.isMarkedCorrupted()) {
            String uuid = CORRUPTED + UUIDs.randomBase64UUID();
            try (IndexOutput output = this.directory().createOutput(uuid, IOContext.DEFAULT);){
                CodecUtil.writeHeader((DataOutput)output, (String)CODEC, (int)2);
                BytesStreamOutput out = new BytesStreamOutput();
                out.writeException(exception);
                BytesReference bytes = out.bytes();
                output.writeVInt(bytes.length());
                BytesRef ref = bytes.toBytesRef();
                output.writeBytes(ref.bytes, ref.offset, ref.length);
                CodecUtil.writeFooter((IndexOutput)output);
            }
            catch (IOException ex) {
                this.logger.warn("Can't mark store as corrupted", (Throwable)ex);
            }
            this.directory().sync(Collections.singleton(uuid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createEmpty() throws IOException {
        this.metadataLock.writeLock().lock();
        try (IndexWriter writer = Store.newIndexWriter(IndexWriterConfig.OpenMode.CREATE, (Directory)this.directory, null);){
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("history_uuid", UUIDs.randomBase64UUID());
            map.put("local_checkpoint", Long.toString(-1L));
            map.put("max_seq_no", Long.toString(-1L));
            map.put("max_unsafe_auto_id_timestamp", "-1");
            Store.updateCommitData(writer, map);
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrapNewHistory() throws IOException {
        this.metadataLock.writeLock().lock();
        try {
            SegmentInfos segmentCommitInfos = this.readLastCommittedSegmentsInfo();
            Map userData = segmentCommitInfos.getUserData();
            String rawLocalCheckpoint = (String)userData.get("local_checkpoint");
            String rawMaxSeqNo = (String)userData.get("max_seq_no");
            assert (rawLocalCheckpoint == null == (rawMaxSeqNo == null)) : "local checkpoint was " + rawLocalCheckpoint + " but max seq no was " + rawMaxSeqNo;
            assert (rawLocalCheckpoint != null || segmentCommitInfos.getCommitLuceneVersion().major < 7) : "Found Lucene version: " + segmentCommitInfos.getCommitLuceneVersion().major;
            SequenceNumbers.CommitInfo seqno = SequenceNumbers.loadSeqNoInfoFromLuceneCommit(userData.entrySet());
            this.bootstrapNewHistory(seqno.localCheckpoint, seqno.maxSeqNo);
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrapNewHistory(long localCheckpoint, long maxSeqNo) throws IOException {
        this.metadataLock.writeLock().lock();
        try (IndexWriter writer = Store.newIndexWriter(IndexWriterConfig.OpenMode.APPEND, (Directory)this.directory, null);){
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("history_uuid", UUIDs.randomBase64UUID());
            map.put("local_checkpoint", Long.toString(localCheckpoint));
            map.put("max_seq_no", Long.toString(maxSeqNo));
            Store.updateCommitData(writer, map);
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associateIndexWithNewTranslog(String translogUUID) throws IOException {
        this.metadataLock.writeLock().lock();
        try (IndexWriter writer = Store.newIndexWriter(IndexWriterConfig.OpenMode.APPEND, (Directory)this.directory, null);){
            if (translogUUID.equals(Store.getUserData(writer).get("translog_uuid"))) {
                throw new IllegalArgumentException("a new translog uuid can't be equal to existing one. got [" + translogUUID + "]");
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("translog_generation", "1");
            map.put("translog_uuid", translogUUID);
            Store.updateCommitData(writer, map);
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ensureIndexHas6xCommitTags() throws IOException {
        this.metadataLock.writeLock().lock();
        try (IndexWriter writer = Store.newIndexWriter(IndexWriterConfig.OpenMode.APPEND, (Directory)this.directory, null);){
            Map<String, String> userData = Store.getUserData(writer);
            HashMap<String, String> maps = new HashMap<String, String>();
            if (!userData.containsKey("history_uuid")) {
                maps.put("history_uuid", UUIDs.randomBase64UUID());
            }
            if (!userData.containsKey("max_seq_no")) {
                assert (!userData.containsKey("local_checkpoint")) : "Inconsistent sequence number markers in commit [" + userData + "]";
                maps.put("max_seq_no", Long.toString(-1L));
                maps.put("local_checkpoint", Long.toString(-1L));
            }
            if (!userData.containsKey("max_unsafe_auto_id_timestamp")) {
                maps.put("max_unsafe_auto_id_timestamp", "-1");
            }
            if (!maps.isEmpty()) {
                this.logger.debug("bootstrap 6.x commit tags [{}], user_data [{}]", maps, userData);
                Store.updateCommitData(writer, maps);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimUnsafeCommits(long lastSyncedGlobalCheckpoint, long minRetainedTranslogGen, Version indexVersionCreated) throws IOException {
        block17: {
            this.metadataLock.writeLock().lock();
            try {
                IndexCommit startingIndexCommit;
                List existingCommits = DirectoryReader.listCommits((Directory)this.directory);
                if (existingCommits.isEmpty()) {
                    throw new IllegalArgumentException("No index found to trim");
                }
                IndexCommit lastIndexCommitCommit = (IndexCommit)existingCommits.get(existingCommits.size() - 1);
                String translogUUID = (String)lastIndexCommitCommit.getUserData().get("translog_uuid");
                if (indexVersionCreated.before(Version.V_6_2_0)) {
                    if (minRetainedTranslogGen == -1L) {
                        startingIndexCommit = (IndexCommit)existingCommits.get(existingCommits.size() - 1);
                    } else {
                        ArrayList<IndexCommit> recoverableCommits = new ArrayList<IndexCommit>();
                        for (IndexCommit commit : existingCommits) {
                            if (minRetainedTranslogGen > Long.parseLong((String)commit.getUserData().get("translog_generation"))) continue;
                            recoverableCommits.add(commit);
                        }
                        assert (!recoverableCommits.isEmpty()) : "No commit point with translog found; commits [" + existingCommits + "], minRetainedTranslogGen [" + minRetainedTranslogGen + "]";
                        startingIndexCommit = CombinedDeletionPolicy.findSafeCommitPoint(recoverableCommits, lastSyncedGlobalCheckpoint);
                    }
                } else {
                    startingIndexCommit = CombinedDeletionPolicy.findSafeCommitPoint(existingCommits, lastSyncedGlobalCheckpoint);
                }
                if (!translogUUID.equals(startingIndexCommit.getUserData().get("translog_uuid"))) {
                    throw new IllegalStateException("starting commit translog uuid [" + (String)startingIndexCommit.getUserData().get("translog_uuid") + "] is not equal to last commit's translog uuid [" + translogUUID + "]");
                }
                this.logger.debug("starting index commit [{}]", (Object)startingIndexCommit.getUserData());
                if (startingIndexCommit.equals((Object)lastIndexCommitCommit)) break block17;
                try (IndexWriter writer = Store.newIndexWriter(IndexWriterConfig.OpenMode.APPEND, (Directory)this.directory, startingIndexCommit);){
                    writer.setLiveCommitData(startingIndexCommit.getUserData().entrySet());
                    writer.commit();
                }
            }
            finally {
                this.metadataLock.writeLock().unlock();
            }
        }
    }

    private static void updateCommitData(IndexWriter writer, Map<String, String> keysToUpdate) throws IOException {
        Map<String, String> userData = Store.getUserData(writer);
        userData.putAll(keysToUpdate);
        writer.setLiveCommitData(userData.entrySet());
        writer.commit();
    }

    private static Map<String, String> getUserData(IndexWriter writer) {
        HashMap<String, String> userData = new HashMap<String, String>();
        writer.getLiveCommitData().forEach(e -> userData.put((String)e.getKey(), (String)e.getValue()));
        return userData;
    }

    private static IndexWriter newIndexWriter(IndexWriterConfig.OpenMode openMode, Directory dir, IndexCommit commit) throws IOException {
        assert (openMode == IndexWriterConfig.OpenMode.APPEND || commit == null) : "can't specify create flag with a commit";
        IndexWriterConfig iwc = new IndexWriterConfig(null).setSoftDeletesField("__soft_deletes").setCommitOnClose(false).setIndexCommit(commit).setMergePolicy(NoMergePolicy.INSTANCE).setOpenMode(openMode);
        return new IndexWriter(dir, iwc);
    }

    public static interface OnClose
    extends Consumer<ShardLock> {
        public static final OnClose EMPTY = new OnClose(){

            @Override
            public void accept(ShardLock Lock2) {
            }
        };
    }

    static class VerifyingIndexInput
    extends ChecksumIndexInput {
        private final IndexInput input;
        private final Checksum digest;
        private final long checksumPosition;
        private final byte[] checksum = new byte[8];
        private long verifiedPosition = 0L;

        VerifyingIndexInput(IndexInput input) {
            this(input, (Checksum)new BufferedChecksum((Checksum)new CRC32()));
        }

        VerifyingIndexInput(IndexInput input, Checksum digest) {
            super("VerifyingIndexInput(" + input + ")");
            this.input = input;
            this.digest = digest;
            this.checksumPosition = input.length() - 8L;
        }

        public byte readByte() throws IOException {
            long pos = this.input.getFilePointer();
            byte b = this.input.readByte();
            if (++pos > this.verifiedPosition) {
                if (pos <= this.checksumPosition) {
                    this.digest.update(b);
                } else {
                    this.checksum[(int)(pos - this.checksumPosition - 1L)] = b;
                }
                this.verifiedPosition = pos;
            }
            return b;
        }

        public void readBytes(byte[] b, int offset, int len) throws IOException {
            long pos = this.input.getFilePointer();
            this.input.readBytes(b, offset, len);
            if (pos + (long)len > this.verifiedPosition) {
                int alreadyVerified = (int)Math.max(0L, this.verifiedPosition - pos);
                if (pos < this.checksumPosition) {
                    if (pos + (long)len < this.checksumPosition) {
                        this.digest.update(b, offset + alreadyVerified, len - alreadyVerified);
                    } else {
                        int checksumOffset = (int)(this.checksumPosition - pos);
                        if (checksumOffset - alreadyVerified > 0) {
                            this.digest.update(b, offset + alreadyVerified, checksumOffset - alreadyVerified);
                        }
                        System.arraycopy(b, offset + checksumOffset, this.checksum, 0, len - checksumOffset);
                    }
                } else {
                    assert (pos - this.checksumPosition < 8L);
                    System.arraycopy(b, offset, this.checksum, (int)(pos - this.checksumPosition), len);
                }
                this.verifiedPosition = pos + (long)len;
            }
        }

        public long getChecksum() {
            return this.digest.getValue();
        }

        public void seek(long pos) throws IOException {
            if (pos < this.verifiedPosition) {
                this.input.seek(pos);
            } else if (this.verifiedPosition > this.getFilePointer()) {
                this.input.seek(this.verifiedPosition);
                this.skipBytes(pos - this.verifiedPosition);
            } else {
                this.skipBytes(pos - this.getFilePointer());
            }
        }

        public void close() throws IOException {
            this.input.close();
        }

        public long getFilePointer() {
            return this.input.getFilePointer();
        }

        public long length() {
            return this.input.length();
        }

        public IndexInput clone() {
            throw new UnsupportedOperationException();
        }

        public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
            throw new UnsupportedOperationException();
        }

        public long getStoredChecksum() {
            return new ByteArrayDataInput(this.checksum).readLong();
        }

        public long verify() throws CorruptIndexException {
            long storedChecksum = this.getStoredChecksum();
            if (this.getChecksum() == storedChecksum) {
                return storedChecksum;
            }
            throw new CorruptIndexException("verification failed : calculated=" + Store.digestToString(this.getChecksum()) + " stored=" + Store.digestToString(storedChecksum), (DataInput)this);
        }
    }

    static class LuceneVerifyingIndexOutput
    extends VerifyingIndexOutput {
        private final StoreFileMetaData metadata;
        private long writtenBytes;
        private final long checksumPosition;
        private String actualChecksum;
        private final byte[] footerChecksum = new byte[8];

        LuceneVerifyingIndexOutput(StoreFileMetaData metadata, IndexOutput out) {
            super(out);
            this.metadata = metadata;
            this.checksumPosition = metadata.length() - 8L;
        }

        @Override
        public void verify() throws IOException {
            String footerDigest = null;
            if (this.metadata.checksum().equals(this.actualChecksum) && this.writtenBytes == this.metadata.length()) {
                ByteArrayIndexInput indexInput = new ByteArrayIndexInput("checksum", this.footerChecksum);
                footerDigest = Store.digestToString(indexInput.readLong());
                if (this.metadata.checksum().equals(footerDigest)) {
                    return;
                }
            }
            throw new CorruptIndexException("verification failed (hardware problem?) : expected=" + this.metadata.checksum() + " actual=" + this.actualChecksum + " footer=" + footerDigest + " writtenLength=" + this.writtenBytes + " expectedLength=" + this.metadata.length() + " (resource=" + this.metadata.toString() + ")", "VerifyingIndexOutput(" + this.metadata.name() + ")");
        }

        @Override
        public void writeByte(byte b) throws IOException {
            long writtenBytes;
            if ((writtenBytes = this.writtenBytes++) >= this.checksumPosition) {
                int index;
                if (writtenBytes == this.checksumPosition) {
                    this.readAndCompareChecksum();
                }
                if ((index = Math.toIntExact(writtenBytes - this.checksumPosition)) < this.footerChecksum.length) {
                    this.footerChecksum[index] = b;
                    if (index == this.footerChecksum.length - 1) {
                        this.verify();
                    }
                } else {
                    this.verify();
                    throw new AssertionError((Object)("write past EOF expected length: " + this.metadata.length() + " writtenBytes: " + writtenBytes));
                }
            }
            this.out.writeByte(b);
        }

        private void readAndCompareChecksum() throws IOException {
            this.actualChecksum = Store.digestToString(this.getChecksum());
            if (!this.metadata.checksum().equals(this.actualChecksum)) {
                throw new CorruptIndexException("checksum failed (hardware problem?) : expected=" + this.metadata.checksum() + " actual=" + this.actualChecksum + " (resource=" + this.metadata.toString() + ")", "VerifyingIndexOutput(" + this.metadata.name() + ")");
            }
        }

        @Override
        public void writeBytes(byte[] b, int offset, int length) throws IOException {
            if (this.writtenBytes + (long)length > this.checksumPosition) {
                for (int i = 0; i < length; ++i) {
                    this.writeByte(b[offset + i]);
                }
            } else {
                this.out.writeBytes(b, offset, length);
                this.writtenBytes += (long)length;
            }
        }
    }

    public static final class RecoveryDiff {
        public final List<StoreFileMetaData> identical;
        public final List<StoreFileMetaData> different;
        public final List<StoreFileMetaData> missing;

        RecoveryDiff(List<StoreFileMetaData> identical, List<StoreFileMetaData> different, List<StoreFileMetaData> missing) {
            this.identical = identical;
            this.different = different;
            this.missing = missing;
        }

        public int size() {
            return this.identical.size() + this.different.size() + this.missing.size();
        }

        public String toString() {
            return "RecoveryDiff{identical=" + this.identical + ", different=" + this.different + ", missing=" + this.missing + '}';
        }
    }

    public static final class MetadataSnapshot
    implements Iterable<StoreFileMetaData>,
    Writeable {
        private final Map<String, StoreFileMetaData> metadata;
        public static final MetadataSnapshot EMPTY = new MetadataSnapshot();
        private final Map<String, String> commitUserData;
        private final long numDocs;
        private static final String DEL_FILE_EXTENSION = "del";
        private static final String LIV_FILE_EXTENSION = "liv";
        private static final String SEGMENT_INFO_EXTENSION = "si";

        public MetadataSnapshot(Map<String, StoreFileMetaData> metadata, Map<String, String> commitUserData, long numDocs) {
            this.metadata = metadata;
            this.commitUserData = commitUserData;
            this.numDocs = numDocs;
        }

        MetadataSnapshot() {
            this.metadata = Collections.emptyMap();
            this.commitUserData = Collections.emptyMap();
            this.numDocs = 0L;
        }

        MetadataSnapshot(IndexCommit commit, Directory directory, Logger logger) throws IOException {
            LoadedMetadata loadedMetadata = MetadataSnapshot.loadMetadata(commit, directory, logger);
            this.metadata = loadedMetadata.fileMetadata;
            this.commitUserData = loadedMetadata.userData;
            this.numDocs = loadedMetadata.numDocs;
            assert (this.metadata.isEmpty() || this.numSegmentFiles() == 1) : "numSegmentFiles: " + this.numSegmentFiles();
        }

        public MetadataSnapshot(StreamInput in) throws IOException {
            int num;
            int size = in.readVInt();
            HashMap<String, StoreFileMetaData> metadata = new HashMap<String, StoreFileMetaData>();
            for (int i = 0; i < size; ++i) {
                StoreFileMetaData meta = new StoreFileMetaData(in);
                metadata.put(meta.name(), meta);
            }
            HashMap<String, String> commitUserData = new HashMap<String, String>();
            for (int i = num = in.readVInt(); i > 0; --i) {
                commitUserData.put(in.readString(), in.readString());
            }
            this.metadata = Collections.unmodifiableMap(metadata);
            this.commitUserData = Collections.unmodifiableMap(commitUserData);
            this.numDocs = in.readLong();
            assert (metadata.isEmpty() || this.numSegmentFiles() == 1) : "numSegmentFiles: " + this.numSegmentFiles();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.metadata.size());
            for (StoreFileMetaData storeFileMetaData : this) {
                storeFileMetaData.writeTo(out);
            }
            out.writeVInt(this.commitUserData.size());
            for (Map.Entry entry : this.commitUserData.entrySet()) {
                out.writeString((String)entry.getKey());
                out.writeString((String)entry.getValue());
            }
            out.writeLong(this.numDocs);
        }

        public long getNumDocs() {
            return this.numDocs;
        }

        static LoadedMetadata loadMetadata(IndexCommit commit, Directory directory, Logger logger) throws IOException {
            long numDocs;
            HashMap<String, StoreFileMetaData> builder = new HashMap<String, StoreFileMetaData>();
            HashMap commitUserDataBuilder = new HashMap();
            try {
                SegmentInfos segmentCommitInfos = Store.readSegmentsInfo(commit, directory);
                numDocs = Lucene.getNumDocs(segmentCommitInfos);
                commitUserDataBuilder.putAll(segmentCommitInfos.getUserData());
                org.apache.lucene.util.Version maxVersion = segmentCommitInfos.getMinSegmentLuceneVersion();
                for (SegmentCommitInfo info : segmentCommitInfos) {
                    org.apache.lucene.util.Version version = info.info.getVersion();
                    if (version == null) {
                        throw new IllegalArgumentException("expected valid version value: " + info.info.toString());
                    }
                    if (version.onOrAfter(maxVersion)) {
                        maxVersion = version;
                    }
                    for (String file : info.files()) {
                        MetadataSnapshot.checksumFromLuceneFile(directory, file, builder, logger, version, SEGMENT_INFO_EXTENSION.equals(IndexFileNames.getExtension((String)file)));
                    }
                }
                if (maxVersion == null) {
                    maxVersion = Version.CURRENT.minimumIndexCompatibilityVersion().luceneVersion;
                }
                String segmentsFile = segmentCommitInfos.getSegmentsFileName();
                MetadataSnapshot.checksumFromLuceneFile(directory, segmentsFile, builder, logger, maxVersion, true);
            }
            catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException | IndexNotFoundException ex) {
                throw ex;
            }
            catch (Exception ex) {
                try {
                    logger.warn(() -> new ParameterizedMessage("failed to build store metadata. checking segment info integrity (with commit [{}])", (Object)(commit == null ? "no" : "yes")), (Throwable)ex);
                    Lucene.checkSegmentInfoIntegrity(directory);
                }
                catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException cex) {
                    cex.addSuppressed(ex);
                    throw cex;
                }
                catch (Exception inner) {
                    inner.addSuppressed(ex);
                    throw inner;
                }
                throw ex;
            }
            return new LoadedMetadata(Collections.unmodifiableMap(builder), Collections.unmodifiableMap(commitUserDataBuilder), numDocs);
        }

        private static void checksumFromLuceneFile(Directory directory, String file, Map<String, StoreFileMetaData> builder, Logger logger, org.apache.lucene.util.Version version, boolean readFileAsHash) throws IOException {
            BytesRefBuilder fileHash = new BytesRefBuilder();
            try (IndexInput in = directory.openInput(file, IOContext.READONCE);){
                String checksum;
                long length;
                try {
                    length = in.length();
                    if (length < (long)CodecUtil.footerLength()) {
                        throw new CorruptIndexException("Can't retrieve checksum from file: " + file + " file length must be >= " + CodecUtil.footerLength() + " but was: " + in.length(), (DataInput)in);
                    }
                    if (readFileAsHash) {
                        VerifyingIndexInput verifyingIndexInput = new VerifyingIndexInput(in);
                        MetadataSnapshot.hashFile(fileHash, new InputStreamIndexInput((IndexInput)verifyingIndexInput, length), length);
                        checksum = Store.digestToString(verifyingIndexInput.verify());
                    } else {
                        checksum = Store.digestToString(CodecUtil.retrieveChecksum((IndexInput)in));
                    }
                }
                catch (Exception ex) {
                    logger.debug(() -> new ParameterizedMessage("Can retrieve checksum from file [{}]", (Object)file), (Throwable)ex);
                    throw ex;
                }
                builder.put(file, new StoreFileMetaData(file, length, checksum, version, fileHash.get()));
            }
        }

        public static void hashFile(BytesRefBuilder fileHash, InputStream in, long size) throws IOException {
            int len = (int)Math.min(0x100000L, size);
            fileHash.grow(len);
            fileHash.setLength(len);
            int readBytes = Streams.readFully(in, fileHash.bytes(), 0, len);
            assert (readBytes == len) : Integer.toString(readBytes) + " != " + Integer.toString(len);
            assert (fileHash.length() == len) : Integer.toString(fileHash.length()) + " != " + Integer.toString(len);
        }

        @Override
        public Iterator<StoreFileMetaData> iterator() {
            return this.metadata.values().iterator();
        }

        public StoreFileMetaData get(String name) {
            return this.metadata.get(name);
        }

        public Map<String, StoreFileMetaData> asMap() {
            return this.metadata;
        }

        public RecoveryDiff recoveryDiff(MetadataSnapshot recoveryTargetSnapshot) {
            ArrayList identical = new ArrayList();
            ArrayList<StoreFileMetaData> different = new ArrayList<StoreFileMetaData>();
            ArrayList<StoreFileMetaData> missing = new ArrayList<StoreFileMetaData>();
            HashMap<String, List> perSegment = new HashMap<String, List>();
            ArrayList<Object> perCommitStoreFiles = new ArrayList<Object>();
            for (Object meta : this) {
                if ("segments.gen".equals(((StoreFileMetaData)meta).name())) continue;
                String segmentId = IndexFileNames.parseSegmentName((String)((StoreFileMetaData)meta).name());
                String extension = IndexFileNames.getExtension((String)((StoreFileMetaData)meta).name());
                if ("segments".equals(segmentId) || DEL_FILE_EXTENSION.equals(extension) || LIV_FILE_EXTENSION.equals(extension)) {
                    perCommitStoreFiles.add(meta);
                    continue;
                }
                perSegment.computeIfAbsent(segmentId, k -> new ArrayList()).add(meta);
            }
            ArrayList<StoreFileMetaData> identicalFiles = new ArrayList<StoreFileMetaData>();
            for (List segmentFiles : Iterables.concat(perSegment.values(), Collections.singleton(perCommitStoreFiles))) {
                identicalFiles.clear();
                boolean consistent = true;
                for (StoreFileMetaData meta : segmentFiles) {
                    StoreFileMetaData storeFileMetaData = recoveryTargetSnapshot.get(meta.name());
                    if (storeFileMetaData == null) {
                        consistent = false;
                        missing.add(meta);
                        continue;
                    }
                    if (!storeFileMetaData.isSame(meta)) {
                        consistent = false;
                        different.add(meta);
                        continue;
                    }
                    identicalFiles.add(meta);
                }
                if (consistent) {
                    identical.addAll(identicalFiles);
                    continue;
                }
                different.addAll(identicalFiles);
            }
            RecoveryDiff recoveryDiff = new RecoveryDiff(Collections.unmodifiableList(identical), Collections.unmodifiableList(different), Collections.unmodifiableList(missing));
            assert (recoveryDiff.size() == this.metadata.size() - (this.metadata.containsKey("segments.gen") ? 1 : 0)) : "some files are missing recoveryDiff size: [" + recoveryDiff.size() + "] metadata size: [" + this.metadata.size() + "] contains  segments.gen: [" + this.metadata.containsKey("segments.gen") + "]";
            return recoveryDiff;
        }

        public int size() {
            return this.metadata.size();
        }

        public Map<String, String> getCommitUserData() {
            return this.commitUserData;
        }

        public String getHistoryUUID() {
            return this.commitUserData.get("history_uuid");
        }

        public boolean contains(String existingFile) {
            return this.metadata.containsKey(existingFile);
        }

        public StoreFileMetaData getSegmentsFile() {
            for (StoreFileMetaData file : this) {
                if (!file.name().startsWith("segments")) continue;
                return file;
            }
            assert (this.metadata.isEmpty());
            return null;
        }

        private int numSegmentFiles() {
            int count = 0;
            for (StoreFileMetaData file : this) {
                if (!file.name().startsWith("segments")) continue;
                ++count;
            }
            return count;
        }

        public String getSyncId() {
            return this.commitUserData.get("sync_id");
        }

        static class LoadedMetadata {
            final Map<String, StoreFileMetaData> fileMetadata;
            final Map<String, String> userData;
            final long numDocs;

            LoadedMetadata(Map<String, StoreFileMetaData> fileMetadata, Map<String, String> userData, long numDocs) {
                this.fileMetadata = fileMetadata;
                this.userData = userData;
                this.numDocs = numDocs;
            }
        }
    }

    static final class StoreDirectory
    extends FilterDirectory {
        private final Logger deletesLogger;

        StoreDirectory(ByteSizeCachingDirectory delegateDirectory, Logger deletesLogger) {
            super((Directory)delegateDirectory);
            this.deletesLogger = deletesLogger;
        }

        long estimateSize() throws IOException {
            return ((ByteSizeCachingDirectory)this.getDelegate()).estimateSizeInBytes();
        }

        public void close() {
            assert (false) : "Nobody should close this directory except of the Store itself";
        }

        public void deleteFile(String msg, String name) throws IOException {
            this.deletesLogger.trace("{}: delete file {}", (Object)msg, (Object)name);
            super.deleteFile(name);
        }

        public void deleteFile(String name) throws IOException {
            this.deleteFile("StoreDirectory.deleteFile", name);
        }

        private void innerClose() throws IOException {
            super.close();
        }

        public String toString() {
            return "store(" + this.in.toString() + ")";
        }

        public Set<String> getPendingDeletions() throws IOException {
            return StoreDirectory.unwrap((Directory)this).getPendingDeletions();
        }
    }
}

