/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.datafeed;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.client.ml.NodeAttributes;
import org.elasticsearch.client.ml.datafeed.DatafeedConfig;
import org.elasticsearch.client.ml.datafeed.DatafeedState;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class DatafeedStats
implements ToXContentObject {
    private final String datafeedId;
    private final DatafeedState datafeedState;
    @Nullable
    private final NodeAttributes node;
    @Nullable
    private final String assignmentExplanation;
    public static final ParseField ASSIGNMENT_EXPLANATION = new ParseField("assignment_explanation", new String[0]);
    public static final ParseField NODE = new ParseField("node", new String[0]);
    public static final ConstructingObjectParser<DatafeedStats, Void> PARSER = new ConstructingObjectParser("datafeed_stats", true, a -> {
        String datafeedId = (String)a[0];
        DatafeedState datafeedState = DatafeedState.fromString((String)a[1]);
        NodeAttributes nodeAttributes = (NodeAttributes)a[2];
        String assignmentExplanation = (String)a[3];
        return new DatafeedStats(datafeedId, datafeedState, nodeAttributes, assignmentExplanation);
    });

    public DatafeedStats(String datafeedId, DatafeedState datafeedState, @Nullable NodeAttributes node, @Nullable String assignmentExplanation) {
        this.datafeedId = Objects.requireNonNull(datafeedId);
        this.datafeedState = Objects.requireNonNull(datafeedState);
        this.node = node;
        this.assignmentExplanation = assignmentExplanation;
    }

    public String getDatafeedId() {
        return this.datafeedId;
    }

    public DatafeedState getDatafeedState() {
        return this.datafeedState;
    }

    public NodeAttributes getNode() {
        return this.node;
    }

    public String getAssignmentExplanation() {
        return this.assignmentExplanation;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DatafeedConfig.ID.getPreferredName(), this.datafeedId);
        builder.field(DatafeedState.STATE.getPreferredName(), this.datafeedState.toString());
        if (this.node != null) {
            builder.startObject("node");
            builder.field("id", this.node.getId());
            builder.field("name", this.node.getName());
            builder.field("ephemeral_id", this.node.getEphemeralId());
            builder.field("transport_address", this.node.getTransportAddress());
            builder.startObject("attributes");
            for (Map.Entry<String, String> entry : this.node.getAttributes().entrySet()) {
                if (!entry.getKey().startsWith("ml.")) continue;
                builder.field(entry.getKey(), entry.getValue());
            }
            builder.endObject();
            builder.endObject();
        }
        if (this.assignmentExplanation != null) {
            builder.field(ASSIGNMENT_EXPLANATION.getPreferredName(), this.assignmentExplanation);
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.datafeedId, this.datafeedState.toString(), this.node, this.assignmentExplanation);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DatafeedStats other = (DatafeedStats)obj;
        return Objects.equals(this.datafeedId, other.datafeedId) && Objects.equals((Object)this.datafeedState, (Object)other.datafeedState) && Objects.equals(this.node, other.node) && Objects.equals(this.assignmentExplanation, other.assignmentExplanation);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), DatafeedConfig.ID);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), DatafeedState.STATE);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), NodeAttributes.PARSER, NODE);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), ASSIGNMENT_EXPLANATION);
    }
}

