/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.elasticsearch.client;

import com.amazonaws.DefaultRequest;
import com.amazonaws.SignableRequest;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.http.HttpMethodName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;

class AwsRequestSigner
implements HttpRequestInterceptor {
    private static final String SERVICE_NAME = "es";
    private final AWSCredentialsProvider credentialsProvider;
    private final AWS4Signer signer;

    public AwsRequestSigner(String region, AWSCredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        this.signer = new AWS4Signer();
        this.signer.setServiceName(SERVICE_NAME);
        this.signer.setRegionName(region);
    }

    public void process(HttpRequest request, HttpContext context) throws IOException {
        HttpEntityEnclosingRequest enclosingRequest;
        String method = request.getRequestLine().getMethod();
        URI uri = URI.create(request.getRequestLine().getUri());
        URIBuilder uriBuilder = new URIBuilder(uri);
        TreeMap<String, List> parameters = new TreeMap<String, List>(String.CASE_INSENSITIVE_ORDER);
        for (NameValuePair parameter : uriBuilder.getQueryParams()) {
            parameters.computeIfAbsent(parameter.getName(), key -> new ArrayList()).add(parameter.getValue());
        }
        Map headers = (Map)Arrays.stream(request.getAllHeaders()).collect(ImmutableMap.toImmutableMap(NameValuePair::getName, NameValuePair::getValue));
        InputStream content = null;
        if (request instanceof HttpEntityEnclosingRequest && (enclosingRequest = (HttpEntityEnclosingRequest)request).getEntity() != null) {
            content = enclosingRequest.getEntity().getContent();
        }
        DefaultRequest awsRequest = new DefaultRequest(SERVICE_NAME);
        HttpHost host = (HttpHost)context.getAttribute("http.target_host");
        if (host != null) {
            awsRequest.setEndpoint(URI.create(host.toURI()));
        }
        awsRequest.setHttpMethod(HttpMethodName.fromValue((String)method));
        awsRequest.setResourcePath(uri.getRawPath());
        awsRequest.setContent(content);
        awsRequest.setParameters(parameters);
        awsRequest.setHeaders(headers);
        this.signer.sign((SignableRequest)awsRequest, this.credentialsProvider.getCredentials());
        Header[] newHeaders = (Header[])awsRequest.getHeaders().entrySet().stream().map(entry -> new BasicHeader((String)entry.getKey(), (String)entry.getValue())).toArray(Header[]::new);
        request.setHeaders(newHeaders);
        InputStream newContent = awsRequest.getContent();
        Preconditions.checkState((newContent == null || request instanceof HttpEntityEnclosingRequest ? 1 : 0) != 0);
        if (newContent != null) {
            BasicHttpEntity entity = new BasicHttpEntity();
            entity.setContent(newContent);
            ((HttpEntityEnclosingRequest)request).setEntity((HttpEntity)entity);
        }
    }
}

