/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.clickhouse;

import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.jdbc.ClickHouseDriver;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.clickhouse.ClickHouseClient;
import io.trino.plugin.clickhouse.ClickHouseConfig;
import io.trino.plugin.clickhouse.ClickHouseConnectionFactory;
import io.trino.plugin.clickhouse.ClickHouseSessionProperties;
import io.trino.plugin.clickhouse.ClickHouseTableProperties;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DecimalModule;
import io.trino.plugin.jdbc.DriverConnectionFactory;
import io.trino.plugin.jdbc.ForBaseJdbc;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcMetadataConfig;
import io.trino.plugin.jdbc.JdbcModule;
import io.trino.plugin.jdbc.credential.CredentialProvider;
import java.sql.Driver;
import java.util.Properties;

public class ClickHouseClientModule
implements Module {
    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(ClickHouseConfig.class);
        JdbcModule.bindSessionPropertiesProvider((Binder)binder, ClickHouseSessionProperties.class);
        binder.bind(JdbcClient.class).annotatedWith(ForBaseJdbc.class).to(ClickHouseClient.class).in(Scopes.SINGLETON);
        JdbcModule.bindTablePropertiesProvider((Binder)binder, ClickHouseTableProperties.class);
        ConfigBinder.configBinder((Binder)binder).bindConfigDefaults(JdbcMetadataConfig.class, config -> config.setDomainCompactionThreshold(1000));
        binder.install((Module)new DecimalModule());
    }

    @Provides
    @Singleton
    @ForBaseJdbc
    public static ConnectionFactory createConnectionFactory(BaseJdbcConfig config, CredentialProvider credentialProvider) {
        Properties properties = new Properties();
        properties.setProperty(ClickHouseClientOption.USE_BINARY_STRING.getKey(), "true");
        return new ClickHouseConnectionFactory((ConnectionFactory)new DriverConnectionFactory((Driver)new ClickHouseDriver(), config.getConnectionUrl(), properties, credentialProvider));
    }
}

