/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.matching.Property;
import io.trino.plugin.jdbc.expression.MatchContext;
import io.trino.plugin.jdbc.expression.TypeParameterPattern;
import io.trino.spi.type.TypeSignatureParameter;
import java.util.Objects;
import java.util.function.Function;

public class TypeParameterCapture
extends TypeParameterPattern {
    private final String name;
    private final Capture<TypeSignatureParameter> capture = Capture.newCapture();
    private final Pattern<TypeSignatureParameter> pattern;

    public TypeParameterCapture(String name) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.pattern = Pattern.typeOf(TypeSignatureParameter.class).with(TypeParameterCapture.self().capturedAs(this.capture));
    }

    @Override
    public Pattern<? extends TypeSignatureParameter> getPattern() {
        return this.pattern;
    }

    @Override
    public void resolve(Captures captures, MatchContext matchContext) {
        TypeSignatureParameter parameter = (TypeSignatureParameter)captures.get(this.capture);
        switch (parameter.getKind()) {
            case TYPE: {
                matchContext.record(this.name, parameter.getTypeSignature());
                break;
            }
            case LONG: {
                matchContext.record(this.name, parameter.getLongLiteral());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported parameter: " + parameter);
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeParameterCapture that = (TypeParameterCapture)o;
        return Objects.equals(this.name, that.name);
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public String toString() {
        return this.name;
    }

    public static Property<TypeSignatureParameter, ?, TypeSignatureParameter> self() {
        return Property.property((String)"self", Function.identity());
    }
}

