/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.plugin.jdbc.BaseJdbcConnectorTableHandle;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class JdbcProcedureHandle
extends BaseJdbcConnectorTableHandle {
    private final ProcedureQuery procedure;
    private final List<JdbcColumnHandle> columns;

    @JsonCreator
    public JdbcProcedureHandle(@JsonProperty ProcedureQuery procedureQuery, @JsonProperty List<JdbcColumnHandle> columns) {
        this.procedure = Objects.requireNonNull(procedureQuery, "procedureQuery is null");
        this.columns = Objects.requireNonNull(columns, "columns is null");
    }

    @JsonProperty
    public ProcedureQuery getProcedureQuery() {
        return this.procedure;
    }

    @Override
    @JsonProperty
    public Optional<List<JdbcColumnHandle>> getColumns() {
        return Optional.of(this.columns);
    }

    public String toString() {
        return String.format("Procedure[%s], Columns=%s", this.procedure, this.columns);
    }

    public record ProcedureQuery(@JsonProperty String query) {
        @JsonCreator
        public ProcedureQuery {
            Objects.requireNonNull(query, "query is null");
        }
    }
}

