/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy;

import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import org.apache.hadoop.hive.common.type.TimestampTZ;
import org.apache.hadoop.hive.common.type.TimestampTZUtil;
import org.apache.hadoop.hive.serde2.io.TimestampLocalTZWritable;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyTimestampLocalTZObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TimestampLocalTZTypeInfo;

public class LazyTimestampLocalTZ
extends LazyPrimitive<LazyTimestampLocalTZObjectInspector, TimestampLocalTZWritable> {
    private static final Logger LOG = LoggerFactory.getLogger(LazyTimestampLocalTZ.class);
    private ZoneId timeZone;

    public LazyTimestampLocalTZ(LazyTimestampLocalTZObjectInspector lazyTimestampTZObjectInspector) {
        super(lazyTimestampTZObjectInspector);
        TimestampLocalTZTypeInfo typeInfo = (TimestampLocalTZTypeInfo)((LazyTimestampLocalTZObjectInspector)this.oi).getTypeInfo();
        if (typeInfo == null) {
            throw new RuntimeException("TimestampLocalTZ type used without type params");
        }
        this.timeZone = typeInfo.timeZone();
        this.data = new TimestampLocalTZWritable();
    }

    public LazyTimestampLocalTZ(LazyTimestampLocalTZ copy) {
        super(copy);
        this.timeZone = copy.timeZone;
        this.data = new TimestampLocalTZWritable((TimestampLocalTZWritable)copy.data);
    }

    @Override
    public void init(ByteArrayRef bytes, int start, int length) {
        String s = null;
        if (!LazyUtils.isDateMaybe(bytes.getData(), start, length)) {
            this.isNull = true;
            return;
        }
        TimestampTZ t = null;
        try {
            s = new String(bytes.getData(), start, length, "US-ASCII");
            if (s.equals("NULL")) {
                this.isNull = true;
                this.logExceptionMessage(bytes, start, length, "timestamp with local time zone".toUpperCase());
            } else {
                t = TimestampTZUtil.parse(s, this.timeZone);
                this.isNull = false;
            }
        }
        catch (UnsupportedEncodingException e) {
            this.isNull = true;
            LOG.error("Unsupported encoding found ", e);
        }
        catch (DateTimeParseException e) {
            this.isNull = true;
            this.logExceptionMessage(bytes, start, length, "timestamp with local time zone".toUpperCase());
        }
        ((TimestampLocalTZWritable)this.data).set(t);
    }

    @Override
    public TimestampLocalTZWritable getWritableObject() {
        return (TimestampLocalTZWritable)this.data;
    }

    public static void writeUTF8(OutputStream out, TimestampLocalTZWritable i) throws IOException {
        if (i == null) {
            out.write(TimestampLocalTZWritable.nullBytes);
        } else {
            out.write(i.toString().getBytes("US-ASCII"));
        }
    }
}

