/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.message;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hive.metastore.messaging.AlterTableMessage;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AbstractMessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;
import org.apache.hadoop.hive.ql.plan.AlterTableDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.stats.StatsUtils;

public class RenameTableHandler
extends AbstractMessageHandler {
    @Override
    public List<Task<? extends Serializable>> handle(MessageHandler.Context context) throws SemanticException {
        AlterTableMessage msg = this.deserializer.getAlterTableMessage(context.dmd.getPayload());
        if (!context.isTableNameEmpty()) {
            throw new SemanticException("RENAMES of tables are not supported for table-level replication");
        }
        try {
            String oldDbName = msg.getTableObjBefore().getDbName();
            String newDbName = msg.getTableObjAfter().getDbName();
            if (!context.isDbNameEmpty()) {
                if (!oldDbName.equalsIgnoreCase(newDbName)) {
                    throw new SemanticException("Cannot replicate an event renaming a table across databases into a db level load " + oldDbName + "->" + newDbName);
                }
                oldDbName = context.dbName;
                newDbName = context.dbName;
            }
            String oldName = StatsUtils.getFullyQualifiedTableName(oldDbName, msg.getTableObjBefore().getTableName());
            String newName = StatsUtils.getFullyQualifiedTableName(newDbName, msg.getTableObjAfter().getTableName());
            AlterTableDesc renameTableDesc = new AlterTableDesc(oldName, newName, false, context.eventOnlyReplicationSpec());
            Task<DDLWork> renameTableTask = TaskFactory.get(new DDLWork((HashSet<ReadEntity>)this.readEntitySet, (HashSet<WriteEntity>)this.writeEntitySet, renameTableDesc), context.hiveConf);
            context.log.debug("Added rename table task : {}:{}->{}", renameTableTask.getId(), oldName, newName);
            this.updatedMetadata.set(context.dmd.getEventTo().toString(), newDbName, msg.getTableObjAfter().getTableName(), null);
            return Collections.singletonList(renameTableTask);
        }
        catch (Exception e) {
            throw e instanceof SemanticException ? (SemanticException)e : new SemanticException("Error reading message members", e);
        }
    }
}

