/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.vector;

import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.io.parquet.vector.VectorizedColumnReader;
import org.apache.hadoop.hive.ql.io.parquet.vector.VectorizedListColumnReader;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class VectorizedMapColumnReader
implements VectorizedColumnReader {
    private VectorizedListColumnReader keyColumnReader;
    private VectorizedListColumnReader valueColumnReader;

    public VectorizedMapColumnReader(VectorizedListColumnReader keyColumnReader, VectorizedListColumnReader valueColumnReader) {
        this.keyColumnReader = keyColumnReader;
        this.valueColumnReader = valueColumnReader;
    }

    @Override
    public void readBatch(int total, ColumnVector column, TypeInfo columnType) throws IOException {
        MapColumnVector mapColumnVector = (MapColumnVector)column;
        MapTypeInfo mapTypeInfo = (MapTypeInfo)columnType;
        ListTypeInfo keyListTypeInfo = new ListTypeInfo();
        keyListTypeInfo.setListElementTypeInfo(mapTypeInfo.getMapKeyTypeInfo());
        ListTypeInfo valueListTypeInfo = new ListTypeInfo();
        valueListTypeInfo.setListElementTypeInfo(mapTypeInfo.getMapValueTypeInfo());
        ListColumnVector keyListColumnVector = new ListColumnVector();
        ListColumnVector valueListColumnVector = new ListColumnVector();
        this.keyColumnReader.readBatch(total, keyListColumnVector, keyListTypeInfo);
        this.valueColumnReader.readBatch(total, valueListColumnVector, valueListTypeInfo);
        mapColumnVector.keys = keyListColumnVector.child;
        mapColumnVector.values = valueListColumnVector.child;
        mapColumnVector.isNull = keyListColumnVector.isNull;
        mapColumnVector.offsets = keyListColumnVector.offsets;
        mapColumnVector.lengths = keyListColumnVector.lengths;
        mapColumnVector.childCount = keyListColumnVector.childCount;
        mapColumnVector.isRepeating = keyListColumnVector.isRepeating && valueListColumnVector.isRepeating;
    }
}

