/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;

public class SmallTableCache {
    private static final Logger LOG = LoggerFactory.getLogger(SmallTableCache.class.getName());
    private static final ConcurrentHashMap<Path, MapJoinTableContainer> tableContainerMap = new ConcurrentHashMap();
    private static volatile String queryId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(Configuration conf) {
        String currentQueryId = conf.get(HiveConf.ConfVars.HIVEQUERYID.varname);
        if (!currentQueryId.equals(queryId)) {
            if (!tableContainerMap.isEmpty()) {
                ConcurrentHashMap<Path, MapJoinTableContainer> concurrentHashMap = tableContainerMap;
                synchronized (concurrentHashMap) {
                    if (!currentQueryId.equals(queryId) && !tableContainerMap.isEmpty()) {
                        for (MapJoinTableContainer tableContainer : tableContainerMap.values()) {
                            tableContainer.clear();
                        }
                        tableContainerMap.clear();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Cleaned up small table cache for query " + queryId);
                        }
                    }
                }
            }
            queryId = currentQueryId;
        }
    }

    public static void cache(Path path, MapJoinTableContainer tableContainer) {
        if (tableContainerMap.putIfAbsent(path, tableContainer) == null && LOG.isDebugEnabled()) {
            LOG.debug("Cached small table file " + path + " for query " + queryId);
        }
    }

    public static MapJoinTableContainer get(Path path) {
        MapJoinTableContainer tableContainer = tableContainerMap.get(path);
        if (tableContainer != null && LOG.isDebugEnabled()) {
            LOG.debug("Loaded small table file " + path + " from cache for query " + queryId);
        }
        return tableContainer;
    }
}

