/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.tools.utils;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ChecksumUtil {
    private static final char[] DIGITS = "0123456789abcdef".toCharArray();

    public static String calculateChecksum(InputStream stream) throws IOException, NoSuchAlgorithmException {
        byte[] buf = new byte[1024];
        int len = 0;
        MessageDigest md = MessageDigest.getInstance("SHA1");
        while ((len = stream.read(buf)) >= 0) {
            md.update(buf, 0, len);
        }
        return ChecksumUtil.toHex(md.digest());
    }

    protected static String toHex(byte[] digest) {
        char[] result = new char[digest.length * 2];
        for (int i = 0; i < digest.length; ++i) {
            ChecksumUtil.toChars(digest[i], result, i * 2);
        }
        return new String(result);
    }

    private static void toChars(byte b, char[] result, int position) {
        result[position + 1] = DIGITS[b & 0xF];
        result[position] = DIGITS[b >> 4 & 0xF];
    }

    private ChecksumUtil() {
    }
}

