/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.metrics.runtime;

import io.smallrye.metrics.MetricsRequestHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.util.concurrent.CountDownLatch;
import org.jboss.logging.Logger;

public class MetricsHttpHandler
implements HttpHandler {
    private static Logger LOG = Logger.getLogger((String)"org.wildfly.swarm.microprofile.metrics");
    private ThreadLocal<CountDownLatch> dispatched = new ThreadLocal();
    private HttpHandler next;
    private final MetricsRequestHandler metricsHandler = new MetricsRequestHandler();

    public MetricsHttpHandler(HttpHandler next) {
        this.next = next;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String requestPath = exchange.getRequestPath();
        if (this.dispatched.get() != null && this.dispatched.get().getCount() == 1L) {
            this.next.handleRequest(exchange);
            this.dispatched.set(null);
            return;
        }
        if (!requestPath.startsWith("/metrics")) {
            this.next.handleRequest(exchange);
            return;
        }
        String method = exchange.getRequestMethod().toString();
        HeaderValues acceptHeaders = exchange.getRequestHeaders().get(Headers.ACCEPT);
        this.metricsHandler.handleRequest(requestPath, method, acceptHeaders == null ? null : acceptHeaders.stream(), (status, message, headers) -> {
            exchange.setStatusCode(status);
            headers.forEach((key, value) -> exchange.getResponseHeaders().put(new HttpString(key), value));
            exchange.getResponseSender().send(message);
        });
    }
}

