/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.spring.boot.autoconfigure.template;

import com.uber.m3.tally.Scope;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.serviceclient.WorkflowServiceStubsOptions;
import io.temporal.spring.boot.TemporalOptionsCustomizer;
import io.temporal.spring.boot.autoconfigure.properties.ConnectionProperties;
import io.temporal.spring.boot.autoconfigure.template.ServiceStubOptionsTemplate;
import io.temporal.spring.boot.autoconfigure.template.TestWorkflowEnvironmentAdapter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ServiceStubsTemplate {
    @Nonnull
    private final ConnectionProperties connectionProperties;
    @Nullable
    private final Scope metricsScope;
    @Nullable
    private final TestWorkflowEnvironmentAdapter testWorkflowEnvironment;
    @Nullable
    private final TemporalOptionsCustomizer<WorkflowServiceStubsOptions.Builder> workflowServiceStubsCustomizer;
    private WorkflowServiceStubs workflowServiceStubs;

    public ServiceStubsTemplate(@Nonnull ConnectionProperties connectionProperties, @Nullable Scope metricsScope, @Nullable TestWorkflowEnvironmentAdapter testWorkflowEnvironment, @Nullable TemporalOptionsCustomizer<WorkflowServiceStubsOptions.Builder> workflowServiceStubsCustomizer) {
        this.connectionProperties = connectionProperties;
        this.metricsScope = metricsScope;
        this.testWorkflowEnvironment = testWorkflowEnvironment;
        this.workflowServiceStubsCustomizer = workflowServiceStubsCustomizer;
    }

    public WorkflowServiceStubs getWorkflowServiceStubs() {
        if (this.workflowServiceStubs == null) {
            this.workflowServiceStubs = this.createServiceStubs();
        }
        return this.workflowServiceStubs;
    }

    private WorkflowServiceStubs createServiceStubs() {
        WorkflowServiceStubs workflowServiceStubs;
        if (this.testWorkflowEnvironment != null) {
            workflowServiceStubs = this.testWorkflowEnvironment.getWorkflowClient().getWorkflowServiceStubs();
        } else {
            switch (this.connectionProperties.getTarget().toLowerCase()) {
                case "local": {
                    workflowServiceStubs = WorkflowServiceStubs.newLocalServiceStubs();
                    break;
                }
                default: {
                    workflowServiceStubs = WorkflowServiceStubs.newServiceStubs((WorkflowServiceStubsOptions)new ServiceStubOptionsTemplate(this.connectionProperties, this.metricsScope, this.workflowServiceStubsCustomizer).createServiceStubOptions());
                }
            }
        }
        return workflowServiceStubs;
    }
}

