/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.testservice;

import io.grpc.BindableService;
import io.grpc.ServerBuilder;
import io.grpc.ServerServiceDefinition;
import io.grpc.health.v1.HealthCheckResponse;
import io.grpc.protobuf.services.HealthStatusManager;
import java.util.Collection;

public class GRPCServerHelper {
    public static void registerServicesAndHealthChecks(Collection<BindableService> services, ServerBuilder<?> toServerBuilder) {
        HealthStatusManager healthStatusManager = new HealthStatusManager();
        for (BindableService service : services) {
            ServerServiceDefinition serverServiceDefinition = service.bindService();
            toServerBuilder.addService(serverServiceDefinition);
            healthStatusManager.setStatus(service.bindService().getServiceDescriptor().getName(), HealthCheckResponse.ServingStatus.SERVING);
        }
        toServerBuilder.addService(healthStatusManager.getHealthService());
    }
}

