/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.workflow;

import io.temporal.common.Experimental;
import java.util.Objects;

public final class TimerOptions {
    private static final TimerOptions DEFAULT_INSTANCE = TimerOptions.newBuilder().build();
    private final String summary;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(TimerOptions options) {
        return new Builder(options);
    }

    public static TimerOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private TimerOptions(String summary) {
        this.summary = summary;
    }

    public String getSummary() {
        return this.summary;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return "TimerOptions{summary='" + this.summary + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimerOptions that = (TimerOptions)o;
        return Objects.equals(this.summary, that.summary);
    }

    public int hashCode() {
        return Objects.hash(this.summary);
    }

    public static final class Builder {
        private String summary;

        private Builder() {
        }

        private Builder(TimerOptions options) {
            if (options == null) {
                return;
            }
            this.summary = options.summary;
        }

        @Experimental
        public Builder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        public TimerOptions build() {
            return new TimerOptions(this.summary);
        }
    }
}

