/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.workflow;

import io.temporal.workflow.Async;
import io.temporal.workflow.Functions;
import io.temporal.workflow.Promise;
import java.util.ArrayList;
import java.util.List;

public final class Saga {
    private final Options options;
    private final List<Functions.Func<Promise>> compensationOps = new ArrayList<Functions.Func<Promise>>();

    public Saga(Options options) {
        this.options = options;
    }

    public void compensate() {
        if (this.options.parallelCompensation) {
            ArrayList<Promise> results = new ArrayList<Promise>();
            for (Functions.Func<Promise> func : this.compensationOps) {
                results.add(func.apply());
            }
            Throwable sagaException = null;
            for (Promise p : results) {
                try {
                    p.get();
                }
                catch (Exception e) {
                    if (sagaException == null) {
                        sagaException = new CompensationException(e);
                        continue;
                    }
                    sagaException.addSuppressed(e);
                }
            }
            if (sagaException != null) {
                throw sagaException;
            }
        } else {
            for (int i = this.compensationOps.size() - 1; i >= 0; --i) {
                Functions.Func<Promise> f = this.compensationOps.get(i);
                try {
                    Promise promise = f.apply();
                    promise.get();
                    continue;
                }
                catch (Exception exception) {
                    if (this.options.continueWithError) continue;
                    throw exception;
                }
            }
        }
    }

    public void addCompensation(Functions.Proc operation) {
        this.compensationOps.add(() -> Async.procedure(operation));
    }

    public <A1> void addCompensation(Functions.Proc1<A1> operation, A1 arg1) {
        this.compensationOps.add(() -> Async.procedure(operation, arg1));
    }

    public <A1, A2> void addCompensation(Functions.Proc2<A1, A2> operation, A1 arg1, A2 arg2) {
        this.compensationOps.add(() -> Async.procedure(operation, arg1, arg2));
    }

    public <A1, A2, A3> void addCompensation(Functions.Proc3<A1, A2, A3> operation, A1 arg1, A2 arg2, A3 arg3) {
        this.compensationOps.add(() -> Async.procedure(operation, arg1, arg2, arg3));
    }

    public <A1, A2, A3, A4> void addCompensation(Functions.Proc4<A1, A2, A3, A4> operation, A1 arg1, A2 arg2, A3 arg3, A4 arg4) {
        this.compensationOps.add(() -> Async.procedure(operation, arg1, arg2, arg3, arg4));
    }

    public <A1, A2, A3, A4, A5> void addCompensation(Functions.Proc5<A1, A2, A3, A4, A5> operation, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5) {
        this.compensationOps.add(() -> Async.procedure(operation, arg1, arg2, arg3, arg4, arg5));
    }

    public <A1, A2, A3, A4, A5, A6> void addCompensation(Functions.Proc6<A1, A2, A3, A4, A5, A6> operation, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6) {
        this.compensationOps.add(() -> Async.procedure(operation, arg1, arg2, arg3, arg4, arg5, arg6));
    }

    public void addCompensation(Functions.Func<?> operation) {
        this.compensationOps.add(() -> Async.function(operation));
    }

    public <A1> void addCompensation(Functions.Func1<A1, ?> operation, A1 arg1) {
        this.compensationOps.add(() -> Async.function(operation, arg1));
    }

    public <A1, A2> void addCompensation(Functions.Func2<A1, A2, ?> operation, A1 arg1, A2 arg2) {
        this.compensationOps.add(() -> Async.function(operation, arg1, arg2));
    }

    public <A1, A2, A3> void addCompensation(Functions.Func3<A1, A2, A3, ?> operation, A1 arg1, A2 arg2, A3 arg3) {
        this.compensationOps.add(() -> Async.function(operation, arg1, arg2, arg3));
    }

    public <A1, A2, A3, A4> void addCompensation(Functions.Func4<A1, A2, A3, A4, ?> operation, A1 arg1, A2 arg2, A3 arg3, A4 arg4) {
        this.compensationOps.add(() -> Async.function(operation, arg1, arg2, arg3, arg4));
    }

    public <A1, A2, A3, A4, A5> void addCompensation(Functions.Func5<A1, A2, A3, A4, A5, ?> operation, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5) {
        this.compensationOps.add(() -> Async.function(operation, arg1, arg2, arg3, arg4, arg5));
    }

    public <A1, A2, A3, A4, A5, A6> void addCompensation(Functions.Func6<A1, A2, A3, A4, A5, A6, ?> operation, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6) {
        this.compensationOps.add(() -> Async.function(operation, arg1, arg2, arg3, arg4, arg5, arg6));
    }

    public static class CompensationException
    extends RuntimeException {
        public CompensationException(Throwable cause) {
            super("Exception from saga compensate", cause);
        }
    }

    public static final class Options {
        private final boolean parallelCompensation;
        private final boolean continueWithError;

        private Options(boolean parallelCompensation, boolean continueWithError) {
            this.parallelCompensation = parallelCompensation;
            this.continueWithError = continueWithError;
        }

        public static final class Builder {
            private boolean parallelCompensation;
            private boolean continueWithError;

            public Builder setParallelCompensation(boolean parallelCompensation) {
                this.parallelCompensation = parallelCompensation;
                return this;
            }

            public Builder setContinueWithError(boolean continueWithError) {
                this.continueWithError = continueWithError;
                return this;
            }

            public Options build() {
                return new Options(this.parallelCompensation, this.continueWithError);
            }
        }
    }
}

