/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.payload.codec;

import com.google.protobuf.ByteString;
import io.temporal.api.common.v1.Payload;
import io.temporal.payload.codec.PayloadCodec;
import io.temporal.payload.codec.PayloadCodecException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.Deflater;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nonnull;

public class ZlibPayloadCodec
implements PayloadCodec {
    static final ByteString METADATA_ENCODING_ZLIB = ByteString.copyFromUtf8((String)"binary/zlib");
    final int level;

    public ZlibPayloadCodec() {
        this(-1);
    }

    public ZlibPayloadCodec(int level) {
        this.level = level;
    }

    @Override
    @Nonnull
    public List<Payload> encode(@Nonnull List<Payload> payloads) {
        return payloads.stream().map(this::encodePayload).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public List<Payload> decode(@Nonnull List<Payload> payloads) {
        return payloads.stream().map(this::decodePayload).collect(Collectors.toList());
    }

    private Payload encodePayload(Payload originalPayload) {
        if (originalPayload.getSerializedSize() < 7) {
            return originalPayload;
        }
        byte[] input = originalPayload.toByteArray();
        int inputSize = input.length;
        Deflater compressor = new Deflater(this.level);
        compressor.setInput(input);
        compressor.finish();
        byte[] output = new byte[inputSize];
        int deflatedLength = compressor.deflate(output);
        compressor.end();
        if (deflatedLength < inputSize) {
            return Payload.newBuilder().putMetadata("encoding", METADATA_ENCODING_ZLIB).setData(ByteString.copyFrom((byte[])output, (int)0, (int)deflatedLength)).build();
        }
        return originalPayload;
    }

    private Payload decodePayload(Payload originalPayload) {
        if (METADATA_ENCODING_ZLIB.equals((Object)originalPayload.getMetadataOrDefault("encoding", null))) {
            Payload payload;
            InflaterInputStream inflaterInputStream = new InflaterInputStream(originalPayload.getData().newInput());
            try {
                payload = Payload.parseFrom((InputStream)inflaterInputStream);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        inflaterInputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new PayloadCodecException(e);
                }
            }
            inflaterInputStream.close();
            return payload;
        }
        return originalPayload;
    }
}

