/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import com.uber.m3.tally.Scope;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.temporal.internal.BackoffThrottler;
import io.temporal.internal.task.VirtualThreadDelegate;
import io.temporal.internal.worker.BasePoller;
import io.temporal.internal.worker.ExecutorThreadFactory;
import io.temporal.internal.worker.PollerOptions;
import io.temporal.internal.worker.ShutdownableTaskExecutor;
import io.temporal.internal.worker.Throttler;
import io.temporal.worker.tuning.PollerBehaviorSimpleMaximum;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MultiThreadedPoller<T>
extends BasePoller<T> {
    private static final Logger log = LoggerFactory.getLogger(MultiThreadedPoller.class);
    private final String identity;
    private final PollTask<T> pollTask;
    private final PollerOptions pollerOptions;
    private final Scope workerMetricsScope;
    private Throttler pollRateThrottler;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler = new BasePoller.PollerUncaughtExceptionHandler();

    public MultiThreadedPoller(String identity, PollTask<T> pollTask, ShutdownableTaskExecutor<T> taskExecutor, PollerOptions pollerOptions, Scope workerMetricsScope) {
        super(taskExecutor);
        Objects.requireNonNull(identity, "identity cannot be null");
        Objects.requireNonNull(pollTask, "poll service should not be null");
        Objects.requireNonNull(pollerOptions, "pollerOptions should not be null");
        Objects.requireNonNull(workerMetricsScope, "workerMetricsScope should not be null");
        this.identity = identity;
        this.pollTask = pollTask;
        this.pollerOptions = pollerOptions;
        this.workerMetricsScope = workerMetricsScope;
    }

    @Override
    public boolean start() {
        log.info("start: {}", (Object)this);
        if (this.pollerOptions.getMaximumPollRatePerSecond() > 0.0) {
            this.pollRateThrottler = new Throttler("poller", this.pollerOptions.getMaximumPollRatePerSecond(), this.pollerOptions.getMaximumPollRateIntervalMilliseconds());
        }
        if (!(this.pollerOptions.getPollerBehavior() instanceof PollerBehaviorSimpleMaximum)) {
            throw new IllegalArgumentException("PollerBehavior " + this.pollerOptions.getPollerBehavior() + " is not supported. Only PollerBehaviorSimpleMaximum is supported.");
        }
        PollerBehaviorSimpleMaximum pollerBehavior = (PollerBehaviorSimpleMaximum)this.pollerOptions.getPollerBehavior();
        if (this.pollerOptions.isUsingVirtualThreads()) {
            AtomicInteger threadIndex = new AtomicInteger();
            this.pollExecutor = VirtualThreadDelegate.newVirtualThreadExecutor(t -> {
                t.setName(this.pollerOptions.getPollThreadNamePrefix() + ": " + threadIndex.incrementAndGet());
                t.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
            });
        } else {
            ThreadPoolExecutor threadPoolPoller = new ThreadPoolExecutor(pollerBehavior.getMaxConcurrentTaskPollers(), pollerBehavior.getMaxConcurrentTaskPollers(), 1L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(pollerBehavior.getMaxConcurrentTaskPollers()));
            threadPoolPoller.setThreadFactory(new ExecutorThreadFactory(this.pollerOptions.getPollThreadNamePrefix(), this.pollerOptions.getUncaughtExceptionHandler()));
            this.pollExecutor = threadPoolPoller;
        }
        for (int i = 0; i < pollerBehavior.getMaxConcurrentTaskPollers(); ++i) {
            this.pollExecutor.execute(new PollLoopTask(new PollExecutionTask()));
            this.workerMetricsScope.counter("temporal_poller_start").inc(1L);
        }
        return true;
    }

    public String toString() {
        return String.format("MultiThreadedPoller{name=%s, identity=%s}", this.pollerOptions.getPollThreadNamePrefix(), this.identity);
    }

    private class PollExecutionTask
    implements ThrowingRunnable {
        private PollExecutionTask() {
        }

        @Override
        public void run() throws Exception {
            Object task = MultiThreadedPoller.this.pollTask.poll();
            if (task != null) {
                MultiThreadedPoller.this.taskExecutor.process(task);
            }
        }
    }

    private class PollLoopTask
    implements Runnable {
        private final ThrowingRunnable task;
        private final BackoffThrottler pollBackoffThrottler;

        PollLoopTask(ThrowingRunnable task) {
            this.task = task;
            this.pollBackoffThrottler = new BackoffThrottler(MultiThreadedPoller.this.pollerOptions.getBackoffInitialInterval(), MultiThreadedPoller.this.pollerOptions.getBackoffCongestionInitialInterval(), MultiThreadedPoller.this.pollerOptions.getBackoffMaximumInterval(), MultiThreadedPoller.this.pollerOptions.getBackoffCoefficient(), MultiThreadedPoller.this.pollerOptions.getBackoffMaximumJitterCoefficient());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                CountDownLatch suspender;
                long throttleMs = this.pollBackoffThrottler.getSleepTime();
                if (throttleMs > 0L) {
                    Thread.sleep(throttleMs);
                }
                if (MultiThreadedPoller.this.pollRateThrottler != null) {
                    MultiThreadedPoller.this.pollRateThrottler.throttle();
                }
                if ((suspender = (CountDownLatch)MultiThreadedPoller.this.suspendLatch.get()) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("poll task suspending latchCount=" + suspender.getCount());
                    }
                    suspender.await();
                }
                if (MultiThreadedPoller.this.shouldTerminate()) {
                    return;
                }
                this.task.run();
                this.pollBackoffThrottler.success();
            }
            catch (Throwable e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                } else {
                    this.pollBackoffThrottler.failure(e instanceof StatusRuntimeException ? ((StatusRuntimeException)e).getStatus().getCode() : Status.Code.UNKNOWN);
                }
                MultiThreadedPoller.this.uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), e);
            }
            finally {
                if (!MultiThreadedPoller.this.shouldTerminate()) {
                    MultiThreadedPoller.this.pollExecutor.execute(this);
                } else {
                    log.info("poll loop is terminated: {}", (Object)MultiThreadedPoller.this.pollTask.getClass().getSimpleName());
                }
            }
        }
    }

    static interface ThrowingRunnable {
        public void run() throws Throwable;
    }

    public static interface PollTask<TT> {
        public TT poll();
    }
}

