/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import io.temporal.internal.worker.LocalActivityAttemptTask;
import io.temporal.internal.worker.LocalActivityExecutionContext;
import io.temporal.internal.worker.LocalActivityResult;
import io.temporal.internal.worker.ShutdownManager;
import io.temporal.internal.worker.Shutdownable;
import io.temporal.internal.worker.SlotReservationData;
import io.temporal.internal.worker.TrackingSlotSupplier;
import io.temporal.worker.tuning.LocalActivitySlotInfo;
import io.temporal.worker.tuning.SlotPermit;
import io.temporal.worker.tuning.SlotReleaseReason;
import io.temporal.worker.tuning.SlotSupplierFuture;
import io.temporal.workflow.Functions;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalActivitySlotSupplierQueue
implements Shutdownable {
    private final PriorityBlockingQueue<QueuedLARequest> requestQueue;
    private final Semaphore newExecutionsBackpressureSemaphore;
    private final TrackingSlotSupplier<LocalActivitySlotInfo> slotSupplier;
    private final Functions.Proc1<LocalActivityAttemptTask> afterReservedCallback;
    private final ExecutorService queueThreadService;
    private static final Logger log = LoggerFactory.getLogger((String)LocalActivitySlotSupplierQueue.class.getName());
    private volatile boolean running = true;
    private volatile boolean wasEverStarted = false;

    LocalActivitySlotSupplierQueue(TrackingSlotSupplier<LocalActivitySlotInfo> slotSupplier, Functions.Proc1<LocalActivityAttemptTask> afterReservedCallback) {
        this.afterReservedCallback = afterReservedCallback;
        int maximumSlots = slotSupplier.maximumSlots().orElse(50) * 2;
        this.newExecutionsBackpressureSemaphore = new Semaphore(maximumSlots);
        this.requestQueue = new PriorityBlockingQueue(maximumSlots, (r1, r2) -> {
            if (r1.isRetry && !r2.isRetry) {
                return -1;
            }
            if (!r1.isRetry && r2.isRetry) {
                return 1;
            }
            return 0;
        });
        this.slotSupplier = slotSupplier;
        this.queueThreadService = Executors.newSingleThreadExecutor(r -> new Thread(r, "LocalActivitySlotSupplierQueue"));
    }

    private void processQueue() {
        while (this.running || !this.requestQueue.isEmpty()) {
            SlotPermit slotPermit = null;
            QueuedLARequest request = null;
            try {
                request = this.requestQueue.take();
                SlotSupplierFuture future = this.slotSupplier.reserveSlot(request.data);
                try {
                    slotPermit = (SlotPermit)future.get();
                }
                catch (InterruptedException e) {
                    SlotPermit maybePermitAnyway = future.abortReservation();
                    if (maybePermitAnyway != null) {
                        this.slotSupplier.releaseSlot(SlotReleaseReason.neverUsed(), maybePermitAnyway);
                    }
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (ExecutionException e) {
                    log.error("Error reserving local activity slot, dropped activity id {}", (Object)request.task.getActivityId(), (Object)e);
                    continue;
                }
                request.task.getExecutionContext().setPermit(slotPermit);
                this.afterReservedCallback.apply(request.task);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (Throwable e) {
                log.error("Unexpected error submitting local activity task to worker", e);
                if (slotPermit != null) {
                    this.slotSupplier.releaseSlot(SlotReleaseReason.error(new RuntimeException(e)), slotPermit);
                }
                if (request != null) {
                    LocalActivityExecutionContext executionContext = request.task.getExecutionContext();
                    executionContext.callback(LocalActivityResult.processingFailed(executionContext.getActivityId(), request.task.getAttemptTask().getAttempt(), e));
                }
                if (!(e.getCause() instanceof InterruptedException)) continue;
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    void start() {
        this.wasEverStarted = true;
        this.queueThreadService.submit(this::processQueue);
    }

    boolean waitOnBackpressure(@Nullable Long acceptanceTimeoutMs) throws InterruptedException {
        boolean accepted;
        if (acceptanceTimeoutMs == null) {
            this.newExecutionsBackpressureSemaphore.acquire();
            accepted = true;
        } else {
            accepted = acceptanceTimeoutMs > 0L ? this.newExecutionsBackpressureSemaphore.tryAcquire(acceptanceTimeoutMs, TimeUnit.MILLISECONDS) : this.newExecutionsBackpressureSemaphore.tryAcquire();
        }
        return accepted;
    }

    void submitAttempt(SlotReservationData data, boolean isRetry, LocalActivityAttemptTask task) {
        QueuedLARequest request = new QueuedLARequest(isRetry, data, task);
        this.requestQueue.add(request);
        if (!isRetry) {
            this.newExecutionsBackpressureSemaphore.release();
        }
    }

    @Override
    public boolean isShutdown() {
        return this.queueThreadService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.queueThreadService.isTerminated();
    }

    @Override
    public CompletableFuture<Void> shutdown(ShutdownManager shutdownManager, boolean interruptTasks) {
        this.running = false;
        this.queueThreadService.shutdownNow();
        return interruptTasks ? shutdownManager.shutdownExecutorNowUntimed(this.queueThreadService, "LocalActivitySlotSupplierQueue") : shutdownManager.shutdownExecutorUntimed(this.queueThreadService, "LocalActivitySlotSupplierQueue");
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) {
        if (!this.wasEverStarted) {
            return;
        }
        ShutdownManager.awaitTermination(this.queueThreadService, unit.toMillis(timeout));
    }

    static final class QueuedLARequest {
        final boolean isRetry;
        final SlotReservationData data;
        final LocalActivityAttemptTask task;

        QueuedLARequest(boolean isRetry, SlotReservationData data, LocalActivityAttemptTask task) {
            this.isRetry = isRetry;
            this.data = data;
            this.task = task;
        }
    }
}

