/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import com.google.common.base.Preconditions;
import io.temporal.api.command.v1.Command;
import io.temporal.api.command.v1.ScheduleActivityTaskCommandAttributes;
import io.temporal.api.command.v1.ScheduleActivityTaskCommandAttributesOrBuilder;
import io.temporal.api.enums.v1.CommandType;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponse;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskCompletedResponse;
import io.temporal.internal.Config;
import io.temporal.internal.worker.EagerActivityDispatcher;
import io.temporal.worker.tuning.SlotPermit;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
class EagerActivitySlotsReservation
implements Closeable {
    private final EagerActivityDispatcher eagerActivityDispatcher;
    private final List<SlotPermit> reservedSlots = new ArrayList<SlotPermit>();

    EagerActivitySlotsReservation(EagerActivityDispatcher eagerActivityDispatcher) {
        this.eagerActivityDispatcher = eagerActivityDispatcher;
    }

    public void applyToRequest(RespondWorkflowTaskCompletedRequest.Builder mutableRequest) {
        for (int i = 0; i < mutableRequest.getCommandsCount(); ++i) {
            ScheduleActivityTaskCommandAttributes commandAttributes;
            Command command = mutableRequest.getCommands(i);
            if (command.getCommandType() != CommandType.COMMAND_TYPE_SCHEDULE_ACTIVITY_TASK || !(commandAttributes = command.getScheduleActivityTaskCommandAttributes()).getRequestEagerExecution()) continue;
            boolean atLimit = this.reservedSlots.size() >= Config.EAGER_ACTIVITIES_LIMIT;
            Optional<Object> permit = Optional.empty();
            if (!atLimit) {
                permit = this.eagerActivityDispatcher.tryReserveActivitySlot((ScheduleActivityTaskCommandAttributesOrBuilder)commandAttributes);
            }
            if (permit.isPresent()) {
                this.reservedSlots.add((SlotPermit)permit.get());
                continue;
            }
            mutableRequest.setCommands(i, command.toBuilder().setScheduleActivityTaskCommandAttributes(commandAttributes.toBuilder().setRequestEagerExecution(false)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleResponse(RespondWorkflowTaskCompletedResponse serverResponse) {
        int activityTasksCount = serverResponse.getActivityTasksCount();
        Preconditions.checkArgument((activityTasksCount <= this.reservedSlots.size() ? 1 : 0) != 0, (String)"Unexpectedly received %s eager activities though we only requested %s", (int)activityTasksCount, (int)this.reservedSlots.size());
        for (PollActivityTaskQueueResponse act : serverResponse.getActivityTasksList()) {
            SlotPermit permit = this.reservedSlots.remove(0);
            this.eagerActivityDispatcher.dispatchActivity(act, permit);
        }
        try {
            this.eagerActivityDispatcher.releaseActivitySlotReservations(this.reservedSlots);
        }
        finally {
            this.reservedSlots.clear();
        }
    }

    @Override
    public void close() {
        if (!this.reservedSlots.isEmpty()) {
            this.eagerActivityDispatcher.releaseActivitySlotReservations(this.reservedSlots);
            this.reservedSlots.clear();
        }
    }
}

