/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.workflow.Functions;
import io.temporal.workflow.NexusOperationHandle;
import java.util.concurrent.atomic.AtomicReference;

public class StartNexusCallInternal {
    private static final ThreadLocal<AtomicReference<NexusOperationHandle<?>>> asyncResult = new ThreadLocal();

    public static boolean isAsync() {
        return asyncResult.get() != null;
    }

    public static <R> void setAsyncResult(NexusOperationHandle<R> handle) {
        AtomicReference<NexusOperationHandle<?>> placeholder = asyncResult.get();
        if (placeholder == null) {
            throw new IllegalStateException("not in invoke invocation");
        }
        placeholder.set(handle);
    }

    public static void initAsyncInvocation() {
        if (asyncResult.get() != null) {
            throw new IllegalStateException("already in start invocation");
        }
        asyncResult.set(new AtomicReference());
    }

    private static <T> NexusOperationHandle<T> getAsyncInvocationResult() {
        AtomicReference<NexusOperationHandle<?>> reference = asyncResult.get();
        if (reference == null) {
            throw new IllegalStateException("initAsyncInvocation wasn't called");
        }
        NexusOperationHandle<?> result = reference.get();
        if (result == null) {
            throw new IllegalStateException("start result wasn't set");
        }
        return result;
    }

    public static void closeAsyncInvocation() {
        asyncResult.remove();
    }

    public static <T, R> NexusOperationHandle<R> startNexusOperation(Functions.Proc operation) {
        StartNexusCallInternal.initAsyncInvocation();
        try {
            operation.apply();
            NexusOperationHandle<T> nexusOperationHandle = StartNexusCallInternal.getAsyncInvocationResult();
            return nexusOperationHandle;
        }
        finally {
            StartNexusCallInternal.closeAsyncInvocation();
        }
    }
}

