/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.failure.TemporalFailure;
import io.temporal.internal.sync.DeterministicRunnerImpl;
import io.temporal.internal.sync.WorkflowInternal;
import io.temporal.internal.sync.WorkflowThread;
import io.temporal.workflow.CancellationScope;
import io.temporal.workflow.CompletablePromise;
import io.temporal.workflow.Functions;
import io.temporal.workflow.Promise;
import io.temporal.workflow.Workflow;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class CompletablePromiseImpl<V>
implements CompletablePromise<V> {
    private V value;
    private RuntimeException failure;
    private boolean completed;
    private final List<Functions.Proc> handlers = new ArrayList<Functions.Proc>();
    private final DeterministicRunnerImpl runner = DeterministicRunnerImpl.currentThreadInternal().getRunner();
    private boolean registeredWithRunner;

    static Promise<Object> promiseAnyOf(Promise<?>[] promises) {
        CompletablePromise<Object> result = Workflow.newPromise();
        for (Promise<?> p : promises) {
            result.completeFrom(p);
        }
        return result;
    }

    static <V> Promise<V> promiseAnyOf(Iterable<Promise<V>> promises) {
        CompletablePromise result = Workflow.newPromise();
        for (Promise<V> p : promises) {
            result.completeFrom(p);
        }
        return result;
    }

    CompletablePromiseImpl() {
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    public V get() {
        return this.getImpl(false);
    }

    @Override
    public V cancellableGet() {
        return this.getImpl(true);
    }

    private V getImpl(boolean cancellable) {
        if (!this.completed) {
            WorkflowThread.await("Feature.get", () -> {
                if (cancellable) {
                    CancellationScope.throwCanceled();
                }
                return this.completed;
            });
        }
        if (this.failure != null) {
            this.unregisterWithRunner();
            this.throwFailure();
        }
        return this.value;
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws TimeoutException {
        return this.cancellableGetImpl(false, timeout, unit);
    }

    @Override
    public V cancellableGet(long timeout, TimeUnit unit) throws TimeoutException {
        return this.cancellableGetImpl(true, timeout, unit);
    }

    public V cancellableGetImpl(boolean cancellable, long timeout, TimeUnit unit) throws TimeoutException {
        if (!this.completed) {
            WorkflowInternal.await(Duration.ofMillis(unit.toMillis(timeout)), "Feature.get", () -> {
                if (cancellable) {
                    CancellationScope.throwCanceled();
                }
                return this.completed;
            });
        }
        if (!this.completed) {
            throw new TimeoutException();
        }
        if (this.failure != null) {
            this.unregisterWithRunner();
            return this.throwFailure();
        }
        return this.value;
    }

    private V throwFailure() {
        if (this.failure instanceof TemporalFailure) {
            this.failure.setStackTrace(Thread.currentThread().getStackTrace());
        }
        throw this.failure;
    }

    @Override
    public RuntimeException getFailure() {
        if (!this.completed) {
            WorkflowThread.await("Feature.get", () -> this.completed);
        }
        if (this.failure != null) {
            this.unregisterWithRunner();
            return this.failure;
        }
        return null;
    }

    private void unregisterWithRunner() {
        if (this.registeredWithRunner) {
            this.runner.forgetFailedPromise(this);
            this.registeredWithRunner = false;
        }
    }

    @Override
    public boolean complete(V value) {
        if (this.completed) {
            return false;
        }
        this.completed = true;
        this.value = value;
        this.invokeHandlers();
        return true;
    }

    @Override
    public boolean completeExceptionally(RuntimeException value) {
        if (this.completed) {
            return false;
        }
        this.completed = true;
        this.failure = value;
        boolean invoked = this.invokeHandlers();
        if (!invoked) {
            this.runner.registerFailedPromise(this);
            this.registeredWithRunner = true;
        }
        return true;
    }

    @Override
    public boolean completeFrom(Promise<V> source) {
        if (this.completed) {
            return false;
        }
        source.handle((value, failure) -> {
            if (failure != null) {
                this.completeExceptionally((RuntimeException)failure);
            } else {
                this.complete(value);
            }
            return null;
        });
        return true;
    }

    @Override
    public <U> Promise<U> thenApply(Functions.Func1<? super V, ? extends U> fn) {
        return this.handle((r, e) -> {
            if (e != null) {
                throw e;
            }
            return fn.apply((Object)r);
        });
    }

    @Override
    public <U> Promise<U> handle(Functions.Func2<? super V, RuntimeException, ? extends U> fn) {
        return this.then(result -> {
            try {
                Object r = fn.apply((V)this.value, this.failure);
                result.complete(r);
            }
            catch (RuntimeException e) {
                result.completeExceptionally(e);
            }
        });
    }

    @Override
    public <U> Promise<U> thenCompose(Functions.Func1<? super V, ? extends Promise<U>> fn) {
        return this.then(result -> {
            if (this.failure != null) {
                result.completeExceptionally(this.failure);
                return;
            }
            try {
                Promise r = (Promise)fn.apply((V)this.value);
                result.completeFrom(r);
            }
            catch (RuntimeException e) {
                result.completeExceptionally(e);
            }
        });
    }

    @Override
    public Promise<V> exceptionally(Functions.Func1<Throwable, ? extends V> fn) {
        return this.then(result -> {
            if (this.failure == null) {
                result.complete(this.value);
                return;
            }
            try {
                Object r = fn.apply(this.failure);
                result.complete(r);
            }
            catch (RuntimeException e) {
                result.completeExceptionally(e);
            }
        });
    }

    private <U> Promise<U> then(Functions.Proc1<CompletablePromise<U>> proc) {
        CompletablePromiseImpl resultPromise = new CompletablePromiseImpl();
        if (this.completed) {
            proc.apply(resultPromise);
            this.unregisterWithRunner();
        } else {
            this.handlers.add(() -> proc.apply(resultPromise));
        }
        return resultPromise;
    }

    private boolean invokeHandlers() {
        for (Functions.Proc handler : this.handlers) {
            handler.apply();
        }
        return !this.handlers.isEmpty();
    }
}

