/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.statemachines;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import io.temporal.api.command.v1.RecordMarkerCommandAttributes;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.enums.v1.CommandType;
import io.temporal.api.enums.v1.EventType;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.history.v1.MarkerRecordedEventAttributes;
import io.temporal.common.converter.DefaultDataConverter;
import io.temporal.common.converter.StdConverterBackwardsCompatAdapter;
import io.temporal.internal.statemachines.CancellableCommand;
import io.temporal.internal.statemachines.EntityStateMachineInitialCommand;
import io.temporal.internal.statemachines.StateMachine;
import io.temporal.internal.statemachines.StateMachineCommandUtils;
import io.temporal.internal.statemachines.StateMachineDefinition;
import io.temporal.internal.statemachines.WorkflowStateMachines;
import io.temporal.workflow.Functions;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class MutableSideEffectStateMachine {
    static final String MARKER_DATA_KEY = "data";
    static final String MARKER_SKIP_COUNT_KEY = "skipCount";
    static final String MARKER_ID_KEY = "id";
    static final String MUTABLE_SIDE_EFFECT_MARKER_NAME = "MutableSideEffect";
    private final String id;
    private final Functions.Func<Boolean> replaying;
    private final Functions.Proc1<CancellableCommand> commandSink;
    private Optional<Payloads> result = Optional.empty();
    private int currentSkipCount;
    private int skipCountFromMarker = Integer.MAX_VALUE;
    public static final StateMachineDefinition<State, ExplicitEvent, InvocationStateMachine> STATE_MACHINE_DEFINITION = StateMachineDefinition.newInstance("MutableSideEffect", State.CREATED, State.MARKER_COMMAND_RECORDED, State.SKIPPED_NOTIFIED).add(State.CREATED, ExplicitEvent.CHECK_EXECUTION_STATE, (State[])new State[]{State.REPLAYING, State.EXECUTING}, InvocationStateMachine::getExecutionState).add(State.EXECUTING, ExplicitEvent.SCHEDULE, (State[])new State[]{State.MARKER_COMMAND_CREATED, State.SKIPPED}, InvocationStateMachine::createMarker).add(State.REPLAYING, ExplicitEvent.SCHEDULE, State.MARKER_COMMAND_CREATED_REPLAYING, InvocationStateMachine::createFakeCommand).add(State.MARKER_COMMAND_CREATED, CommandType.COMMAND_TYPE_RECORD_MARKER, State.RESULT_NOTIFIED, InvocationStateMachine::notifyCachedResult).add(State.SKIPPED, CommandType.COMMAND_TYPE_RECORD_MARKER, State.SKIPPED_NOTIFIED, InvocationStateMachine::cancelCommandNotifyCachedResult).add(State.RESULT_NOTIFIED, EventType.EVENT_TYPE_MARKER_RECORDED, State.MARKER_COMMAND_RECORDED).add(State.MARKER_COMMAND_CREATED_REPLAYING, CommandType.COMMAND_TYPE_RECORD_MARKER, State.RESULT_NOTIFIED_REPLAYING).add(State.RESULT_NOTIFIED_REPLAYING, ExplicitEvent.NON_MATCHING_EVENT, State.SKIPPED_NOTIFIED, InvocationStateMachine::cancelCommandNotifyCachedResult).add(State.RESULT_NOTIFIED_REPLAYING, (ExplicitEvent)EventType.EVENT_TYPE_MARKER_RECORDED, (State[])new State[]{State.MARKER_COMMAND_RECORDED, State.SKIPPED_NOTIFIED}, InvocationStateMachine::notifyFromEvent);

    public static MutableSideEffectStateMachine newInstance(String id, Functions.Func<Boolean> replaying, Functions.Proc1<CancellableCommand> commandSink, Functions.Proc1<StateMachine> stateMachineSink) {
        return new MutableSideEffectStateMachine(id, replaying, commandSink, stateMachineSink);
    }

    private MutableSideEffectStateMachine(String id, Functions.Func<Boolean> replaying, Functions.Proc1<CancellableCommand> commandSink, Functions.Proc1<StateMachine> stateMachineSink) {
        this.id = Objects.requireNonNull(id);
        this.replaying = Objects.requireNonNull(replaying);
        this.commandSink = Objects.requireNonNull(commandSink);
    }

    public void mutableSideEffect(Functions.Func1<Optional<Payloads>, Optional<Payloads>> func, Functions.Proc1<Optional<Payloads>> callback, Functions.Proc1<StateMachine> stateMachineSink) {
        InvocationStateMachine ism = new InvocationStateMachine(func, callback, stateMachineSink);
        ism.explicitEvent(ExplicitEvent.CHECK_EXECUTION_STATE);
        ism.explicitEvent(ExplicitEvent.SCHEDULE);
    }

    @VisibleForTesting
    class InvocationStateMachine
    extends EntityStateMachineInitialCommand<State, ExplicitEvent, InvocationStateMachine> {
        private final Functions.Proc1<Optional<Payloads>> resultCallback;
        private final Functions.Func1<Optional<Payloads>, Optional<Payloads>> func;

        InvocationStateMachine(Functions.Func1<Optional<Payloads>, Optional<Payloads>> func, Functions.Proc1<Optional<Payloads>> callback, Functions.Proc1<StateMachine> stateMachineSink) {
            super(STATE_MACHINE_DEFINITION, MutableSideEffectStateMachine.this.commandSink, stateMachineSink);
            this.func = Objects.requireNonNull(func);
            this.resultCallback = Objects.requireNonNull(callback);
        }

        State getExecutionState() {
            return (Boolean)MutableSideEffectStateMachine.this.replaying.apply() != false ? State.REPLAYING : State.EXECUTING;
        }

        @Override
        public WorkflowStateMachines.HandleEventStatus handleEvent(HistoryEvent event, boolean hasNextEvent) {
            if (event.getEventType() != EventType.EVENT_TYPE_MARKER_RECORDED || !event.getMarkerRecordedEventAttributes().getMarkerName().equals(MutableSideEffectStateMachine.MUTABLE_SIDE_EFFECT_MARKER_NAME)) {
                this.explicitEvent(ExplicitEvent.NON_MATCHING_EVENT);
                return WorkflowStateMachines.HandleEventStatus.NON_MATCHING_EVENT;
            }
            Map detailsMap = event.getMarkerRecordedEventAttributes().getDetailsMap();
            Optional<Payloads> idPayloads = Optional.ofNullable((Payloads)detailsMap.get(MutableSideEffectStateMachine.MARKER_ID_KEY));
            String expectedId = StdConverterBackwardsCompatAdapter.fromPayloads(0, idPayloads, String.class, String.class);
            if (Strings.isNullOrEmpty((String)expectedId)) {
                throw new IllegalStateException("Marker details map missing required key: id");
            }
            if (!MutableSideEffectStateMachine.this.id.equals(expectedId)) {
                this.explicitEvent(ExplicitEvent.NON_MATCHING_EVENT);
                return WorkflowStateMachines.HandleEventStatus.NON_MATCHING_EVENT;
            }
            return super.handleEvent(event, hasNextEvent);
        }

        State createMarker() {
            Optional<Payloads> updated = this.func.apply(MutableSideEffectStateMachine.this.result);
            if (!updated.isPresent()) {
                MutableSideEffectStateMachine.this.currentSkipCount++;
                this.addCommand(StateMachineCommandUtils.RECORD_MARKER_FAKE_COMMAND);
                return State.SKIPPED;
            }
            MutableSideEffectStateMachine.this.result = updated;
            HashMap<String, Payloads> details = new HashMap<String, Payloads>();
            details.put(MutableSideEffectStateMachine.MARKER_ID_KEY, DefaultDataConverter.STANDARD_INSTANCE.toPayloads(MutableSideEffectStateMachine.this.id).get());
            details.put(MutableSideEffectStateMachine.MARKER_DATA_KEY, updated.get());
            details.put(MutableSideEffectStateMachine.MARKER_SKIP_COUNT_KEY, DefaultDataConverter.STANDARD_INSTANCE.toPayloads(MutableSideEffectStateMachine.this.currentSkipCount).get());
            RecordMarkerCommandAttributes markerAttributes = RecordMarkerCommandAttributes.newBuilder().setMarkerName(MutableSideEffectStateMachine.MUTABLE_SIDE_EFFECT_MARKER_NAME).putAllDetails(details).build();
            this.addCommand(StateMachineCommandUtils.createRecordMarker(markerAttributes));
            MutableSideEffectStateMachine.this.currentSkipCount = 0;
            return State.MARKER_COMMAND_CREATED;
        }

        void createFakeCommand() {
            this.addCommand(StateMachineCommandUtils.RECORD_MARKER_FAKE_COMMAND);
        }

        State notifyFromEvent() {
            State r = this.notifyFromEventImpl();
            this.notifyCachedResult();
            return r;
        }

        State notifyFromEventImpl() {
            MarkerRecordedEventAttributes attributes = this.currentEvent.getMarkerRecordedEventAttributes();
            Map detailsMap = attributes.getDetailsMap();
            Optional<Payloads> skipCountPayloads = Optional.ofNullable((Payloads)detailsMap.get(MutableSideEffectStateMachine.MARKER_SKIP_COUNT_KEY));
            if (!skipCountPayloads.isPresent()) {
                throw new IllegalStateException("Marker details detailsMap missing required key: skipCount");
            }
            Optional<Payloads> oid = Optional.ofNullable((Payloads)detailsMap.get(MutableSideEffectStateMachine.MARKER_ID_KEY));
            String idFromMarker = StdConverterBackwardsCompatAdapter.fromPayloads(0, oid, String.class, String.class);
            if (!MutableSideEffectStateMachine.this.id.equals(idFromMarker)) {
                throw new IllegalArgumentException("Ids doesnt match: " + MutableSideEffectStateMachine.this.id + "<>" + idFromMarker);
            }
            MutableSideEffectStateMachine.this.skipCountFromMarker = StdConverterBackwardsCompatAdapter.fromPayloads(0, skipCountPayloads, Integer.class, Integer.class);
            if (++MutableSideEffectStateMachine.this.currentSkipCount < MutableSideEffectStateMachine.this.skipCountFromMarker) {
                MutableSideEffectStateMachine.this.skipCountFromMarker = Integer.MAX_VALUE;
                return State.SKIPPED_NOTIFIED;
            }
            if (!attributes.getMarkerName().equals(MutableSideEffectStateMachine.MUTABLE_SIDE_EFFECT_MARKER_NAME)) {
                throw new IllegalStateException("Expected MutableSideEffect, received: " + attributes);
            }
            MutableSideEffectStateMachine.this.currentSkipCount = 0;
            MutableSideEffectStateMachine.this.result = Optional.ofNullable((Payloads)detailsMap.get(MutableSideEffectStateMachine.MARKER_DATA_KEY));
            return State.MARKER_COMMAND_RECORDED;
        }

        void notifyCachedResult() {
            this.resultCallback.apply(MutableSideEffectStateMachine.this.result);
        }

        void cancelCommandNotifyCachedResult() {
            this.cancelCommand();
            this.notifyCachedResult();
        }
    }

    static enum State {
        CREATED,
        REPLAYING,
        EXECUTING,
        MARKER_COMMAND_CREATED,
        SKIPPED,
        CACHED_RESULT_NOTIFIED,
        RESULT_NOTIFIED,
        SKIPPED_NOTIFIED,
        RESULT_NOTIFIED_REPLAYING,
        MARKER_COMMAND_CREATED_REPLAYING,
        MARKER_COMMAND_RECORDED;

    }

    static enum ExplicitEvent {
        CHECK_EXECUTION_STATE,
        SCHEDULE,
        NON_MATCHING_EVENT;

    }
}

