/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.common;

import java.lang.invoke.SerializedLambda;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class JavaLambdaUtils {
    public static Object getTarget(SerializedLambda l) {
        if (l == null) {
            return null;
        }
        if (l.getCapturedArgCount() > 0) {
            return l.getCapturedArg(0);
        }
        return null;
    }

    public static SerializedLambda toSerializedLambda(Object lambda) {
        for (Class<?> cl = lambda.getClass(); cl != null; cl = cl.getSuperclass()) {
            try {
                Method m = cl.getDeclaredMethod("writeReplace", new Class[0]);
                m.setAccessible(true);
                Object replacement = m.invoke(lambda, new Object[0]);
                if (replacement instanceof SerializedLambda) {
                    return (SerializedLambda)replacement;
                }
                break;
            }
            catch (NoSuchMethodException m) {
                continue;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                break;
            }
        }
        return null;
    }

    private JavaLambdaUtils() {
    }
}

