/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.common;

import io.temporal.api.failure.v1.Failure;
import io.temporal.failure.ApplicationErrorCategory;
import io.temporal.failure.ApplicationFailure;
import javax.annotation.Nullable;

public class FailureUtils {
    private FailureUtils() {
    }

    public static boolean isBenignApplicationFailure(@Nullable Throwable t) {
        return t instanceof ApplicationFailure && ((ApplicationFailure)t).getCategory() == ApplicationErrorCategory.BENIGN;
    }

    public static boolean isBenignApplicationFailure(@Nullable Failure failure) {
        return failure != null && failure.getApplicationFailureInfo() != null && FailureUtils.categoryFromProto(failure.getApplicationFailureInfo().getCategory()) == ApplicationErrorCategory.BENIGN;
    }

    public static ApplicationErrorCategory categoryFromProto(io.temporal.api.enums.v1.ApplicationErrorCategory protoCategory) {
        if (protoCategory == null) {
            return ApplicationErrorCategory.UNSPECIFIED;
        }
        switch (protoCategory) {
            case APPLICATION_ERROR_CATEGORY_BENIGN: {
                return ApplicationErrorCategory.BENIGN;
            }
        }
        return ApplicationErrorCategory.UNSPECIFIED;
    }

    public static io.temporal.api.enums.v1.ApplicationErrorCategory categoryToProto(ApplicationErrorCategory category) {
        switch (category) {
            case BENIGN: {
                return io.temporal.api.enums.v1.ApplicationErrorCategory.APPLICATION_ERROR_CATEGORY_BENIGN;
            }
        }
        return io.temporal.api.enums.v1.ApplicationErrorCategory.APPLICATION_ERROR_CATEGORY_UNSPECIFIED;
    }
}

