/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.activity;

import io.temporal.activity.ManualActivityCompletionClient;
import io.temporal.failure.CanceledFailure;
import io.temporal.workflow.Functions;
import javax.annotation.Nonnull;

final class CompletionAwareManualCompletionClient
implements ManualActivityCompletionClient {
    private final ManualActivityCompletionClient client;
    private final Functions.Proc completionHandle;

    CompletionAwareManualCompletionClient(ManualActivityCompletionClient client, Functions.Proc completionHandle) {
        this.client = client;
        this.completionHandle = completionHandle;
    }

    @Override
    public void complete(Object result) {
        try {
            this.client.complete(result);
        }
        finally {
            this.completionHandle.apply();
        }
    }

    @Override
    public void fail(@Nonnull Throwable failure) {
        try {
            this.client.fail(failure);
        }
        finally {
            this.completionHandle.apply();
        }
    }

    @Override
    public void recordHeartbeat(Object details) throws CanceledFailure {
        this.client.recordHeartbeat(details);
    }

    @Override
    public void reportCancellation(Object details) {
        try {
            this.client.reportCancellation(details);
        }
        finally {
            this.completionHandle.apply();
        }
    }
}

