/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.failure;

import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.RetryState;
import io.temporal.failure.TemporalFailure;
import java.util.Objects;

public final class ChildWorkflowFailure
extends TemporalFailure {
    private final long initiatedEventId;
    private final long startedEventId;
    private final String namespace;
    private final RetryState retryState;
    private final WorkflowExecution execution;
    private final String workflowType;

    public ChildWorkflowFailure(long initiatedEventId, long startedEventId, String workflowType, WorkflowExecution execution, String namespace, RetryState retryState, Throwable cause) {
        super(ChildWorkflowFailure.getMessage(execution, workflowType, initiatedEventId, startedEventId, namespace, retryState), null, cause);
        this.execution = Objects.requireNonNull(execution);
        this.workflowType = Objects.requireNonNull(workflowType);
        this.initiatedEventId = initiatedEventId;
        this.startedEventId = startedEventId;
        this.namespace = namespace;
        this.retryState = retryState;
    }

    public long getInitiatedEventId() {
        return this.initiatedEventId;
    }

    public long getStartedEventId() {
        return this.startedEventId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public RetryState getRetryState() {
        return this.retryState;
    }

    public WorkflowExecution getExecution() {
        return this.execution;
    }

    public String getWorkflowType() {
        return this.workflowType;
    }

    public static String getMessage(WorkflowExecution execution, String workflowType, long initiatedEventId, long startedEventId, String namespace, RetryState retryState) {
        return "workflowId='" + execution.getWorkflowId() + '\'' + ", runId='" + execution.getRunId() + '\'' + ", workflowType='" + workflowType + '\'' + ", initiatedEventId=" + initiatedEventId + ", startedEventId=" + startedEventId + ", namespace='" + namespace + '\'' + ", retryState=" + retryState;
    }
}

