/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common.converter;

import com.google.common.base.Preconditions;
import io.temporal.common.converter.ByteArrayPayloadConverter;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.converter.FailureConverter;
import io.temporal.common.converter.GlobalDataConverter;
import io.temporal.common.converter.JacksonJsonPayloadConverter;
import io.temporal.common.converter.NullPayloadConverter;
import io.temporal.common.converter.PayloadAndFailureDataConverter;
import io.temporal.common.converter.PayloadConverter;
import io.temporal.common.converter.ProtobufJsonPayloadConverter;
import io.temporal.common.converter.ProtobufPayloadConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.annotation.Nonnull;

public class DefaultDataConverter
extends PayloadAndFailureDataConverter {
    public static final PayloadConverter[] STANDARD_PAYLOAD_CONVERTERS = new PayloadConverter[]{new NullPayloadConverter(), new ByteArrayPayloadConverter(), new ProtobufJsonPayloadConverter(), new ProtobufPayloadConverter(), new JacksonJsonPayloadConverter()};
    public static final DataConverter STANDARD_INSTANCE = DefaultDataConverter.newDefaultInstance();

    public static void setDefaultDataConverter(DataConverter converter) {
        GlobalDataConverter.register(converter);
    }

    public static DefaultDataConverter newDefaultInstance() {
        return new DefaultDataConverter(STANDARD_PAYLOAD_CONVERTERS);
    }

    public DefaultDataConverter(PayloadConverter ... converters) {
        super(Arrays.asList(converters));
    }

    public DefaultDataConverter withPayloadConverterOverrides(PayloadConverter ... overrideConverters) {
        ArrayList<PayloadConverter> newConverters = new ArrayList<PayloadConverter>(this.converters);
        for (PayloadConverter overrideConverter : overrideConverters) {
            PayloadConverter existingConverter = (PayloadConverter)this.convertersMap.get(overrideConverter.getEncodingType());
            if (existingConverter != null) {
                int existingConverterIndex = newConverters.indexOf(existingConverter);
                newConverters.set(existingConverterIndex, overrideConverter);
                continue;
            }
            newConverters.add(overrideConverter);
        }
        this.converters = Collections.unmodifiableList(newConverters);
        this.convertersMap = Collections.unmodifiableMap(DefaultDataConverter.createConvertersMap(this.converters));
        return this;
    }

    @Nonnull
    public DefaultDataConverter withFailureConverter(@Nonnull FailureConverter failureConverter) {
        this.failureConverter = (FailureConverter)Preconditions.checkNotNull((Object)failureConverter, (Object)"failureConverter");
        return this;
    }
}

