/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.history.v1.History;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.common.converter.DataConverterException;
import io.temporal.internal.common.HistoryJsonUtils;
import java.util.List;

public final class WorkflowExecutionHistory
extends io.temporal.internal.common.WorkflowExecutionHistory {
    public WorkflowExecutionHistory(History history) {
        super(history);
    }

    public WorkflowExecutionHistory(History history, String workflowId) {
        super(history, workflowId);
    }

    public static WorkflowExecutionHistory fromJson(String serialized) {
        String protoJson = HistoryJsonUtils.historyFormatJsonToProtoJson(serialized);
        JsonFormat.Parser parser = JsonFormat.parser().ignoringUnknownFields();
        History.Builder historyBuilder = History.newBuilder();
        try {
            parser.merge(protoJson, (Message.Builder)historyBuilder);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DataConverterException(e);
        }
        History history = historyBuilder.build();
        String workflowId = io.temporal.internal.common.WorkflowExecutionHistory.extractWorkflowId(history);
        return new WorkflowExecutionHistory(history, workflowId);
    }

    public static WorkflowExecutionHistory fromJson(String serialized, String workflowId) {
        String protoJson = HistoryJsonUtils.historyFormatJsonToProtoJson(serialized);
        JsonFormat.Parser parser = JsonFormat.parser().ignoringUnknownFields();
        History.Builder historyBuilder = History.newBuilder();
        try {
            parser.merge(protoJson, (Message.Builder)historyBuilder);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DataConverterException(e);
        }
        History history = historyBuilder.build();
        return new WorkflowExecutionHistory(history, workflowId);
    }

    @Override
    public String toJson(boolean prettyPrint) {
        return super.toJson(prettyPrint);
    }

    @Override
    public String toProtoText(boolean showWorkflowTasks) {
        return super.toProtoText(showWorkflowTasks);
    }

    @Override
    public WorkflowExecution getWorkflowExecution() {
        return super.getWorkflowExecution();
    }

    @Override
    public List<HistoryEvent> getEvents() {
        return super.getEvents();
    }

    @Override
    public HistoryEvent getLastEvent() {
        return super.getLastEvent();
    }

    @Override
    public History getHistory() {
        return super.getHistory();
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

