/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import io.temporal.api.enums.v1.TaskQueueKind;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class StickyQueueBalancer {
    private final int pollersCount;
    private final boolean stickyQueueEnabled;
    private final AtomicInteger stickyPollers = new AtomicInteger(0);
    private final AtomicInteger normalPollers = new AtomicInteger(0);
    private volatile long stickyBacklogSize = 0L;

    public StickyQueueBalancer(int pollersCount, boolean stickyQueueEnabled) {
        this.pollersCount = pollersCount;
        this.stickyQueueEnabled = stickyQueueEnabled;
    }

    public TaskQueueKind makePoll() {
        if (this.stickyQueueEnabled && (this.stickyBacklogSize > (long)this.pollersCount || this.stickyPollers.get() <= this.normalPollers.get())) {
            this.stickyPollers.incrementAndGet();
            return TaskQueueKind.TASK_QUEUE_KIND_STICKY;
        }
        this.normalPollers.incrementAndGet();
        return TaskQueueKind.TASK_QUEUE_KIND_NORMAL;
    }

    public void finishPoll(TaskQueueKind taskQueueKind) {
        switch (taskQueueKind) {
            case TASK_QUEUE_KIND_NORMAL: {
                this.normalPollers.decrementAndGet();
                break;
            }
            case TASK_QUEUE_KIND_STICKY: {
                this.stickyPollers.decrementAndGet();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid task queue kind: " + taskQueueKind);
            }
        }
    }

    public void finishPoll(TaskQueueKind taskQueueKind, long backlogSize) {
        this.finishPoll(taskQueueKind);
        if (TaskQueueKind.TASK_QUEUE_KIND_STICKY.equals((Object)taskQueueKind)) {
            this.stickyBacklogSize = backlogSize;
        }
    }
}

