/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

class CircularLongBuffer {
    private final long[] values_;

    public CircularLongBuffer(int size) {
        this.values_ = new long[size];
    }

    public CircularLongBuffer(long[] values) {
        this.values_ = values;
    }

    public void set(long i, long value) {
        this.values_[this.getArrayOffset((long)i)] = value;
    }

    public long get(long i) {
        return this.values_[this.getArrayOffset(i)];
    }

    public int size() {
        return this.values_.length;
    }

    public CircularLongBuffer copy(long index1, int length) {
        if (length == 0) {
            return new CircularLongBuffer(0);
        }
        int i1 = this.getArrayOffset(index1);
        int i2 = this.getArrayOffset(index1 + (long)Math.min(length, this.values_.length));
        long[] result = new long[length];
        if (i1 < i2) {
            int l = i2 - i1;
            System.arraycopy(this.values_, i1, result, 0, l);
        } else {
            int tailLength = this.values_.length - i1;
            System.arraycopy(this.values_, i1, result, 0, tailLength);
            System.arraycopy(this.values_, 0, result, tailLength, i2);
        }
        return new CircularLongBuffer(result);
    }

    private int getArrayOffset(long index) {
        if (this.values_.length == 0) {
            throw new IllegalStateException("zero data size");
        }
        int result = (int)(index % (long)this.values_.length);
        if (result < 0) {
            result = this.values_.length + result;
        }
        return result;
    }
}

