/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.statemachines;

import com.google.common.base.Preconditions;
import io.temporal.api.enums.v1.EventType;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.history.v1.HistoryEventOrBuilder;
import io.temporal.internal.common.WorkflowExecutionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class WFTBuffer {
    private WFTState wftSequenceState = WFTState.None;
    private final List<HistoryEvent> wftBuffer = new ArrayList<HistoryEvent>();
    private final List<HistoryEvent> readyToFetch = new ArrayList<HistoryEvent>();

    public boolean addEvent(HistoryEvent event, boolean hasNextEvent) {
        if (this.readyToFetch.size() > 0) {
            throw new IllegalStateException("Can't add more events until the readyToFetch is fetched");
        }
        this.handleEvent(event, hasNextEvent);
        return !this.readyToFetch.isEmpty();
    }

    private void handleEvent(HistoryEvent event, boolean hasNextEvent) {
        if (!hasNextEvent) {
            this.flushBuffer();
            this.wftSequenceState = WFTState.None;
            this.readyToFetch.add(event);
            return;
        }
        if (EventType.EVENT_TYPE_WORKFLOW_TASK_STARTED.equals((Object)event.getEventType())) {
            this.flushBuffer();
            this.wftSequenceState = WFTState.Started;
            this.addToBuffer(event);
            return;
        }
        if (WFTState.Started.equals((Object)this.wftSequenceState) && WorkflowExecutionUtils.isWorkflowTaskClosedEvent((HistoryEventOrBuilder)event)) {
            this.wftSequenceState = WFTState.Closed;
            this.addToBuffer(event);
            return;
        }
        if (WFTState.Closed.equals((Object)this.wftSequenceState) && !WorkflowExecutionUtils.isCommandEvent(event)) {
            this.flushBuffer();
            this.wftSequenceState = WFTState.None;
            this.readyToFetch.add(event);
            return;
        }
        if (WFTState.None.equals((Object)this.wftSequenceState)) {
            this.readyToFetch.add(event);
        } else {
            this.addToBuffer(event);
        }
    }

    private void flushBuffer() {
        this.readyToFetch.addAll(this.wftBuffer);
        this.wftBuffer.clear();
    }

    private void addToBuffer(HistoryEvent event) {
        Preconditions.checkState((!WFTState.None.equals((Object)this.wftSequenceState) ? 1 : 0) != 0, (Object)"We should be inside an open WFT sequence to add to the buffer");
        this.wftBuffer.add(event);
    }

    public List<HistoryEvent> fetch() {
        if (this.readyToFetch.size() == 1) {
            HistoryEvent event = this.readyToFetch.get(0);
            this.readyToFetch.clear();
            return Collections.singletonList(event);
        }
        ArrayList<HistoryEvent> result = new ArrayList<HistoryEvent>(this.readyToFetch);
        this.readyToFetch.clear();
        return result;
    }

    private static enum WFTState {
        None,
        Started,
        Closed;

    }
}

