/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.common;

import io.grpc.Deadline;
import io.temporal.api.common.v1.RetryPolicy;
import io.temporal.common.RetryOptions;
import io.temporal.failure.ActivityFailure;
import io.temporal.failure.ApplicationFailure;
import io.temporal.failure.ChildWorkflowFailure;
import io.temporal.internal.common.ProtobufTimeUtils;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class RetryOptionsUtils {
    public static boolean isNotRetryable(RetryOptions o, @Nullable Throwable e) {
        if (e == null) {
            return false;
        }
        if (e instanceof ActivityFailure || e instanceof ChildWorkflowFailure) {
            e = e.getCause();
        }
        String type = e instanceof ApplicationFailure ? ((ApplicationFailure)e).getType() : e.getClass().getName();
        return RetryOptionsUtils.isNotRetryable(o, type);
    }

    public static boolean isNotRetryable(RetryOptions o, @Nullable String type) {
        if (type == null) {
            return false;
        }
        if (o.getDoNotRetry() != null) {
            for (String doNotRetry : o.getDoNotRetry()) {
                if (!doNotRetry.equals(type)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean areAttemptsReached(RetryOptions o, long attempt) {
        return o.getMaximumAttempts() != 0 && attempt >= (long)o.getMaximumAttempts();
    }

    public static boolean isDeadlineReached(@Nullable Deadline deadline, long sleepTimeMs) {
        return deadline != null && deadline.timeRemaining(TimeUnit.MILLISECONDS) < sleepTimeMs;
    }

    public static RetryOptions toRetryOptions(RetryPolicy retryPolicy) {
        Duration initialInterval;
        RetryOptions.Builder roBuilder = RetryOptions.newBuilder();
        Duration maximumInterval = ProtobufTimeUtils.toJavaDuration(retryPolicy.getMaximumInterval());
        if (!maximumInterval.isZero()) {
            roBuilder.setMaximumInterval(maximumInterval);
        }
        if (!(initialInterval = ProtobufTimeUtils.toJavaDuration(retryPolicy.getInitialInterval())).isZero()) {
            roBuilder.setInitialInterval(initialInterval);
        }
        if (retryPolicy.getBackoffCoefficient() >= 1.0) {
            roBuilder.setBackoffCoefficient(retryPolicy.getBackoffCoefficient());
        }
        if (retryPolicy.getMaximumAttempts() > 0) {
            roBuilder.setMaximumAttempts(retryPolicy.getMaximumAttempts());
        }
        roBuilder.setDoNotRetry((String[])retryPolicy.getNonRetryableErrorTypesList().toArray((Object[])new String[retryPolicy.getNonRetryableErrorTypesCount()]));
        return roBuilder.validateBuildWithDefaults();
    }
}

