/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client;

import com.google.common.base.Objects;
import io.temporal.client.UpdateWaitPolicy;
import java.lang.reflect.Type;
import java.util.UUID;

public final class UpdateOptions<T> {
    private static final UpdateOptions DEFAULT_INSTANCE = UpdateOptions.newBuilder().build();
    private final String updateName;
    private final String updateId;
    private final String firstExecutionRunId;
    private final UpdateWaitPolicy waitPolicy;
    private final Class<T> resultClass;
    private final Type resultType;

    public static <T> Builder<T> newBuilder() {
        return new Builder();
    }

    public static <T> Builder<T> newBuilder(Class<T> resultClass) {
        return new Builder<T>().setResultClass(resultClass);
    }

    public static Builder newBuilder(UpdateOptions options) {
        return new Builder(options);
    }

    public static UpdateOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private UpdateOptions(String updateName, String updateId, String firstExecutionRunId, UpdateWaitPolicy waitPolicy, Class<T> resultClass, Type resultType) {
        this.updateName = updateName;
        this.updateId = updateId;
        this.firstExecutionRunId = firstExecutionRunId;
        this.waitPolicy = waitPolicy;
        this.resultClass = resultClass;
        this.resultType = resultType;
    }

    public String getUpdateName() {
        return this.updateName;
    }

    public String getUpdateId() {
        return this.updateId;
    }

    public String getFirstExecutionRunId() {
        return this.firstExecutionRunId;
    }

    public UpdateWaitPolicy getWaitPolicy() {
        return this.waitPolicy;
    }

    public Class<T> getResultClass() {
        return this.resultClass;
    }

    public Type getResultType() {
        return this.resultType;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateOptions that = (UpdateOptions)o;
        return Objects.equal((Object)this.updateName, (Object)that.updateName) && this.updateId == that.updateId && this.firstExecutionRunId == that.firstExecutionRunId && this.waitPolicy.equals((Object)that.waitPolicy) && this.resultClass.equals(that.resultClass) && this.resultType.equals(that.resultType);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.updateName, this.updateId, this.firstExecutionRunId, this.waitPolicy, this.resultClass, this.resultType});
    }

    public String toString() {
        return "StartUpdateOptions{updateName='" + this.updateName + ", updateId=" + this.updateId + ", firstExecutionRunId=" + this.firstExecutionRunId + ", waitPolicy=" + (Object)((Object)this.waitPolicy) + ", resultClass=" + this.resultClass + ", resultType='" + this.resultType + '}';
    }

    public void validate() {
        if (this.updateName == null || this.updateName.isEmpty()) {
            throw new IllegalStateException("updateName must be a non empty string");
        }
        if (this.resultClass == null) {
            throw new IllegalStateException("resultClass must not be null");
        }
    }

    public static final class Builder<T> {
        private String updateName;
        private String updateId;
        private String firstExecutionRunId;
        private UpdateWaitPolicy waitPolicy;
        private Class<T> resultClass;
        private Type resultType;

        private Builder() {
        }

        private Builder(UpdateOptions<T> options) {
            if (options == null) {
                return;
            }
            this.updateName = ((UpdateOptions)options).updateName;
            this.updateId = ((UpdateOptions)options).updateId;
            this.firstExecutionRunId = ((UpdateOptions)options).firstExecutionRunId;
            this.waitPolicy = ((UpdateOptions)options).waitPolicy;
            this.resultClass = ((UpdateOptions)options).resultClass;
            this.resultType = ((UpdateOptions)options).resultType;
        }

        public Builder<T> setUpdateName(String updateName) {
            this.updateName = updateName;
            return this;
        }

        public Builder<T> setUpdateId(String updateId) {
            this.updateId = updateId;
            return this;
        }

        public Builder<T> setFirstExecutionRunId(String firstExecutionRunId) {
            this.firstExecutionRunId = firstExecutionRunId;
            return this;
        }

        public Builder<T> setWaitPolicy(UpdateWaitPolicy waitPolicy) {
            this.waitPolicy = waitPolicy;
            return this;
        }

        public Builder<T> setResultClass(Class<T> resultClass) {
            this.resultClass = resultClass;
            return this;
        }

        public Builder<T> setResultType(Type resultType) {
            this.resultType = resultType;
            return this;
        }

        public UpdateOptions<T> build() {
            if (this.updateId == null || this.updateId.isEmpty()) {
                this.updateId = UUID.randomUUID().toString();
            }
            return new UpdateOptions(this.updateName, this.updateId, this.firstExecutionRunId == null ? "" : this.firstExecutionRunId, this.waitPolicy == null ? UpdateWaitPolicy.ACCEPTED : this.waitPolicy, this.resultClass, this.resultType == null ? this.resultClass : this.resultType);
        }
    }
}

