/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.processors;

import io.swagger.models.ArrayModel;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.refs.RefFormat;
import io.swagger.parser.ResolverCache;
import io.swagger.parser.util.RefUtils;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExternalRefProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalRefProcessor.class);
    private final ResolverCache cache;
    private final Swagger swagger;

    public ExternalRefProcessor(ResolverCache cache, Swagger swagger) {
        this.cache = cache;
        this.swagger = swagger;
    }

    public String processRefToExternalDefinition(String $ref, RefFormat refFormat) {
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        Model model = this.cache.loadRef($ref, refFormat, Model.class);
        if (model == null) {
            LOGGER.warn("unable to load model reference from `" + $ref + "`.  It may not be available or the reference isn't a valid model schema");
            return $ref;
        }
        LinkedHashMap definitions = this.swagger.getDefinitions();
        if (definitions == null) {
            definitions = new LinkedHashMap();
        }
        String possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref);
        String tryName = null;
        Model existingModel = (Model)definitions.get(possiblyConflictingDefinitionName);
        if (existingModel != null) {
            LOGGER.debug("A model for " + existingModel + " already exists");
            if (existingModel instanceof RefModel) {
                existingModel = null;
            } else {
                int i = 2;
                for (String name : definitions.keySet()) {
                    if (!name.equals(possiblyConflictingDefinitionName)) continue;
                    tryName = possiblyConflictingDefinitionName + "_" + i;
                    existingModel = (Model)definitions.get(tryName);
                    ++i;
                }
            }
        }
        String newRef = StringUtils.isNotBlank(tryName) ? tryName : possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingModel == null) {
            ModelImpl modelImpl;
            Property additionalProperties;
            this.swagger.addDefinition(newRef, model);
            this.cache.addReferencedKey(newRef);
            String file = $ref.split("#/")[0];
            if (model instanceof RefModel) {
                RefModel refModel = (RefModel)model;
                if (RefUtils.isAnExternalRefFormat(refModel.getRefFormat())) {
                    refModel.set$ref(this.processRefToExternalDefinition(refModel.get$ref(), refModel.getRefFormat()));
                } else {
                    this.processRefToExternalDefinition(file + refModel.get$ref(), RefFormat.RELATIVE);
                }
            }
            if (model instanceof ComposedModel) {
                ComposedModel composedModel = (ComposedModel)model;
                List listOfAllOF = composedModel.getAllOf();
                for (Model allOfModel : listOfAllOF) {
                    if (allOfModel instanceof RefModel) {
                        RefModel refModel = (RefModel)allOfModel;
                        if (RefUtils.isAnExternalRefFormat(refModel.getRefFormat())) {
                            String joinedRef = ExternalRefProcessor.join(file, refModel.get$ref());
                            refModel.set$ref(this.processRefToExternalDefinition(joinedRef, refModel.getRefFormat()));
                            continue;
                        }
                        this.processRefToExternalDefinition(file + refModel.get$ref(), RefFormat.RELATIVE);
                        continue;
                    }
                    if (!(allOfModel instanceof ModelImpl)) continue;
                    this.processProperties(allOfModel.getProperties(), file);
                }
            }
            this.processProperties(model.getProperties(), file);
            if (model instanceof ModelImpl && (additionalProperties = (modelImpl = (ModelImpl)model).getAdditionalProperties()) != null) {
                if (additionalProperties instanceof RefProperty) {
                    this.processRefProperty((RefProperty)additionalProperties, file);
                } else if (additionalProperties instanceof ArrayProperty) {
                    ArrayProperty arrayProp = (ArrayProperty)additionalProperties;
                    if (arrayProp.getItems() instanceof RefProperty) {
                        this.processRefProperty((RefProperty)arrayProp.getItems(), file);
                    }
                } else if (additionalProperties instanceof MapProperty) {
                    MapProperty mapProp = (MapProperty)additionalProperties;
                    if (mapProp.getAdditionalProperties() instanceof RefProperty) {
                        this.processRefProperty((RefProperty)mapProp.getAdditionalProperties(), file);
                    } else if (mapProp.getAdditionalProperties() instanceof ArrayProperty && ((ArrayProperty)mapProp.getAdditionalProperties()).getItems() instanceof RefProperty) {
                        this.processRefProperty((RefProperty)((ArrayProperty)mapProp.getAdditionalProperties()).getItems(), file);
                    }
                }
            }
            if (model instanceof ArrayModel && ((ArrayModel)model).getItems() instanceof RefProperty) {
                this.processRefProperty((RefProperty)((ArrayModel)model).getItems(), file);
            }
        }
        return newRef;
    }

    public void processRefToExternalResponse(String $ref, RefFormat refFormat) {
        Response response = this.cache.loadRef($ref, refFormat, Response.class);
        if (response != null) {
            String file = $ref.split("#/")[0];
            Model model = null;
            if (response.getResponseSchema() != null && (model = response.getResponseSchema()) instanceof RefModel) {
                RefModel refModel = (RefModel)model;
                if (RefUtils.isAnExternalRefFormat(refFormat)) {
                    this.processRefModel(refModel, $ref);
                } else {
                    this.processRefToExternalDefinition(file + refModel.get$ref(), RefFormat.RELATIVE);
                }
            }
        }
    }

    private void processProperties(Map<String, Property> subProps, String file) {
        if (subProps == null || 0 == subProps.entrySet().size()) {
            return;
        }
        for (Map.Entry<String, Property> prop : subProps.entrySet()) {
            if (prop.getValue() instanceof RefProperty) {
                this.processRefProperty((RefProperty)prop.getValue(), file);
                continue;
            }
            if (prop.getValue() instanceof ArrayProperty) {
                ArrayProperty arrayProp = (ArrayProperty)prop.getValue();
                if (!(arrayProp.getItems() instanceof RefProperty)) continue;
                this.processRefProperty((RefProperty)arrayProp.getItems(), file);
                continue;
            }
            if (!(prop.getValue() instanceof MapProperty)) continue;
            MapProperty mapProp = (MapProperty)prop.getValue();
            if (mapProp.getAdditionalProperties() instanceof RefProperty) {
                this.processRefProperty((RefProperty)mapProp.getAdditionalProperties(), file);
                continue;
            }
            if (!(mapProp.getAdditionalProperties() instanceof ArrayProperty) || !(((ArrayProperty)mapProp.getAdditionalProperties()).getItems() instanceof RefProperty)) continue;
            this.processRefProperty((RefProperty)((ArrayProperty)mapProp.getAdditionalProperties()).getItems(), file);
        }
    }

    private void processRefProperty(RefProperty subRef, String externalFile) {
        if (RefUtils.isAnExternalRefFormat(subRef.getRefFormat())) {
            String joinedRef = ExternalRefProcessor.join(externalFile, subRef.get$ref());
            subRef.set$ref(this.processRefToExternalDefinition(joinedRef, subRef.getRefFormat()));
        } else {
            this.processRefToExternalDefinition(externalFile + subRef.get$ref(), RefFormat.RELATIVE);
        }
    }

    private void processRefModel(RefModel subRef, String externalFile) {
        if (RefUtils.isAnExternalRefFormat(subRef.getRefFormat())) {
            String joinedRef = ExternalRefProcessor.join(externalFile, subRef.get$ref());
            subRef.set$ref(this.processRefToExternalDefinition(joinedRef, subRef.getRefFormat()));
        } else {
            this.processRefToExternalDefinition(externalFile + subRef.get$ref(), RefFormat.RELATIVE);
        }
    }

    public static String join(String source, String fragment) {
        try {
            boolean isRelative = false;
            if (source.startsWith("/") || source.startsWith(".")) {
                isRelative = true;
            }
            URI uri = new URI(source);
            if (!source.endsWith("/") && fragment.startsWith("./") && "".equals(uri.getPath())) {
                uri = new URI(source + "/");
            } else if ("".equals(uri.getPath()) && !fragment.startsWith("/")) {
                uri = new URI(source + "/");
            }
            URI f = new URI(fragment);
            URI resolved = uri.resolve(f);
            URI normalized = resolved.normalize();
            if (Character.isAlphabetic(normalized.toString().charAt(0)) && isRelative) {
                return "./" + normalized.toString();
            }
            return normalized.toString();
        }
        catch (Exception e) {
            return source;
        }
    }
}

