/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators;

import io.swagger.codegen.v3.CodegenContent;
import io.swagger.codegen.v3.CodegenOperation;
import io.swagger.codegen.v3.CodegenParameter;
import io.swagger.codegen.v3.generators.DefaultCodegenConfig;
import io.swagger.codegen.v3.generators.util.OpenAPIUtil;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.CookieParameter;
import io.swagger.v3.oas.models.parameters.HeaderParameter;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.PathParameter;
import io.swagger.v3.oas.models.parameters.QueryParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OperationParameters {
    private CodegenParameter bodyParam = null;
    private List<CodegenParameter> allParams = new ArrayList<CodegenParameter>();
    private List<CodegenParameter> bodyParams = new ArrayList<CodegenParameter>();
    private List<CodegenParameter> pathParams = new ArrayList<CodegenParameter>();
    private List<CodegenParameter> queryParams = new ArrayList<CodegenParameter>();
    private List<CodegenParameter> headerParams = new ArrayList<CodegenParameter>();
    private List<CodegenParameter> cookieParams = new ArrayList<CodegenParameter>();
    private List<CodegenParameter> formParams = new ArrayList<CodegenParameter>();
    private List<CodegenParameter> requiredParams = new ArrayList<CodegenParameter>();
    private List<CodegenContent> codegenContents = new ArrayList<CodegenContent>();

    public void setBodyParam(CodegenParameter bodyParam) {
        this.bodyParam = bodyParam;
    }

    public CodegenParameter getBodyParam() {
        return this.bodyParam;
    }

    public List<CodegenParameter> getAllParams() {
        return this.allParams;
    }

    public List<CodegenParameter> getBodyParams() {
        return this.bodyParams;
    }

    public List<CodegenParameter> getPathParams() {
        return this.pathParams;
    }

    public List<CodegenParameter> getQueryParams() {
        return this.queryParams;
    }

    public List<CodegenParameter> getHeaderParams() {
        return this.headerParams;
    }

    public List<CodegenParameter> getCookieParams() {
        return this.cookieParams;
    }

    public List<CodegenParameter> getFormParams() {
        return this.formParams;
    }

    public List<CodegenParameter> getRequiredParams() {
        return this.requiredParams;
    }

    public List<CodegenContent> getCodegenContents() {
        return this.codegenContents;
    }

    public void addAllParams(CodegenParameter codegenParameter) {
        this.allParams.add(codegenParameter);
    }

    public void addBodyParams(CodegenParameter codegenParameter) {
        this.bodyParams.add(codegenParameter);
    }

    public void addPathParams(CodegenParameter codegenParameter) {
        this.pathParams.add(codegenParameter);
    }

    public void addQueryParams(CodegenParameter codegenParameter) {
        this.queryParams.add(codegenParameter);
    }

    public void addHeaderParams(CodegenParameter codegenParameter) {
        this.headerParams.add(codegenParameter);
    }

    public void addCookieParams(CodegenParameter codegenParameter) {
        this.cookieParams.add(codegenParameter);
    }

    public void addFormParam(CodegenParameter codegenParameter) {
        this.formParams.add(codegenParameter);
    }

    public void addRequiredParam(CodegenParameter codegenParameter) {
        this.requiredParams.add(codegenParameter);
    }

    public void addCodegenContents(CodegenContent codegenContent) {
        this.codegenContents.add(codegenContent);
    }

    public void addParameters(Parameter parameter, CodegenParameter codegenParameter) {
        this.allParams.add(codegenParameter);
        if (parameter instanceof QueryParameter || "query".equalsIgnoreCase(parameter.getIn())) {
            this.queryParams.add(codegenParameter.copy());
        } else if (parameter instanceof PathParameter || "path".equalsIgnoreCase(parameter.getIn())) {
            this.pathParams.add(codegenParameter.copy());
        } else if (parameter instanceof HeaderParameter || "header".equalsIgnoreCase(parameter.getIn())) {
            this.headerParams.add(codegenParameter.copy());
        } else if (parameter instanceof CookieParameter || "cookie".equalsIgnoreCase(parameter.getIn())) {
            this.cookieParams.add(codegenParameter.copy());
        }
        if (codegenParameter.required) {
            this.requiredParams.add(codegenParameter.copy());
        }
    }

    public void addHasMore(CodegenOperation codegenOperation) {
        codegenOperation.allParams = OperationParameters.addHasMore(this.allParams);
        codegenOperation.bodyParams = OperationParameters.addHasMore(this.bodyParams);
        codegenOperation.pathParams = OperationParameters.addHasMore(this.pathParams);
        codegenOperation.queryParams = OperationParameters.addHasMore(this.queryParams);
        codegenOperation.headerParams = OperationParameters.addHasMore(this.headerParams);
        codegenOperation.cookieParams = OperationParameters.addHasMore(this.cookieParams);
        codegenOperation.formParams = OperationParameters.addHasMore(this.formParams);
        codegenOperation.requiredParams = OperationParameters.addHasMore(this.requiredParams);
    }

    public void sortRequiredAllParams() {
        Collections.sort(this.allParams, (one, another) -> {
            if (one.required == another.required) {
                return 0;
            }
            if (one.required) {
                return -1;
            }
            return 1;
        });
    }

    public void parseNestedObjects(String name, Schema schema, Set<String> imports, DefaultCodegenConfig codegenConfig, OpenAPI openAPI) {
        if ((schema = OpenAPIUtil.getRefSchemaIfExists(schema, openAPI)) == null || !this.isObjectWithProperties(schema)) {
            return;
        }
        Map properties = schema.getProperties();
        for (String key : properties.keySet()) {
            Schema property = (Schema)properties.get(key);
            property = OpenAPIUtil.getRefSchemaIfExists(property, openAPI);
            boolean required = schema.getRequired() == null || schema.getRequired().isEmpty() ? false : schema.getRequired().stream().anyMatch(propertyName -> key.equalsIgnoreCase(propertyName.toString()));
            String parameterName = property instanceof ArraySchema ? String.format("%s[%s][]", name, key) : String.format("%s[%s]", name, key);
            if (this.isObjectWithProperties(property)) {
                this.parseNestedObjects(parameterName, property, imports, codegenConfig, openAPI);
                continue;
            }
            Parameter queryParameter = new QueryParameter().name(parameterName).required(Boolean.valueOf(required)).schema(property);
            CodegenParameter codegenParameter = codegenConfig.fromParameter(queryParameter, imports);
            this.addParameters(queryParameter, codegenParameter);
        }
    }

    public static List<CodegenParameter> addHasMore(List<CodegenParameter> codegenParameters) {
        if (codegenParameters == null || codegenParameters.isEmpty()) {
            return codegenParameters;
        }
        for (int i = 0; i < codegenParameters.size(); ++i) {
            codegenParameters.get((int)i).secondaryParam = i > 0;
            codegenParameters.get(i).getVendorExtensions().put("x-has-more", i < codegenParameters.size() - 1);
        }
        return codegenParameters;
    }

    private boolean isObjectWithProperties(Schema schema) {
        return ("object".equalsIgnoreCase(schema.getType()) || schema.getType() == null) && schema.getProperties() != null && !schema.getProperties().isEmpty();
    }
}

