/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model.visitors;

import io.sundr.builder.Builder;
import io.sundr.builder.Visitor;
import io.sundr.model.ClassRef;
import io.sundr.model.ClassRefBuilder;
import io.sundr.model.ClassRefFluent;
import io.sundr.model.MethodBuilder;
import io.sundr.model.PropertyBuilder;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeDefBuilder;
import io.sundr.model.TypeRef;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;

public class ReplacePackage
implements Visitor<Builder> {
    private final String target;
    private final String replacement;
    private final Visitor<ClassRefFluent<?>> visitor;

    public ReplacePackage(final String target, final String replacement) {
        this.target = target;
        this.replacement = replacement;
        this.visitor = new Visitor<ClassRefFluent<?>>(){

            public void visit(ClassRefFluent<?> ref) {
                ref.withFullyQualifiedName(ref.getFullyQualifiedName().replaceFirst(target, replacement));
            }
        };
    }

    public void visit(Builder builder) {
        if (builder instanceof TypeDefBuilder) {
            this.visitTypeDefBuilder((TypeDefBuilder)builder);
        } else if (builder instanceof ClassRefBuilder) {
            this.visitClassRefBuilder((ClassRefBuilder)builder);
        } else if (builder instanceof PropertyBuilder) {
            this.visitPropertyBuilder((PropertyBuilder)builder);
        } else if (builder instanceof MethodBuilder) {
            this.visitMethodBuilder((MethodBuilder)builder);
        }
    }

    private void visitMethodBuilder(MethodBuilder builder) {
        if (builder.getReturnType() instanceof ClassRef) {
            ClassRefBuilder classRefBuilder = new ClassRefBuilder((ClassRef)builder.getReturnType());
            builder.withReturnType((TypeRef)((ClassRefBuilder)classRefBuilder.accept(new Visitor[]{this.visitor, this})).build());
        }
    }

    private void visitPropertyBuilder(PropertyBuilder builder) {
        if (builder.getTypeRef() instanceof ClassRef) {
            ClassRefBuilder classRefBuilder = new ClassRefBuilder((ClassRef)builder.getTypeRef());
            builder.withTypeRef((TypeRef)((ClassRefBuilder)classRefBuilder.accept(new Visitor[]{this.visitor, this})).build());
        }
    }

    private void visitClassRefBuilder(ClassRefBuilder builder) {
        ((ClassRefBuilder)builder.withFullyQualifiedName(builder.getFullyQualifiedName().replace(this.target, this.replacement))).accept(new Visitor[]{this.visitor});
        ArrayList<Object> updatedArguments = new ArrayList<Object>();
        for (TypeRef arg : builder.getArguments()) {
            if (arg instanceof ClassRef && ((ClassRef)arg).getPackageName().equals(this.target)) {
                updatedArguments.add(((ClassRefBuilder)new ClassRefBuilder((ClassRef)arg).accept(new Visitor[]{this.visitor})).build());
                continue;
            }
            updatedArguments.add(arg);
        }
        builder.withArguments(updatedArguments);
    }

    private void visitTypeDefBuilder(TypeDefBuilder builder) {
        if (this.target.equals(builder.getPackageName())) {
            builder.withPackageName(this.replacement);
        }
        if (builder.getAttributes().containsKey(TypeDef.ALSO_IMPORT)) {
            LinkedHashSet<ClassRef> updatedImports = new LinkedHashSet<ClassRef>();
            for (ClassRef classRef : (Set)builder.getAttributes().get(TypeDef.ALSO_IMPORT)) {
                if (this.target.equals(classRef.getPackageName())) {
                    updatedImports.add(((ClassRefBuilder)new ClassRefBuilder(classRef).accept(new Visitor[]{this})).build());
                    continue;
                }
                updatedImports.add(classRef);
            }
            builder.getAttributes().put(TypeDef.ALSO_IMPORT, updatedImports);
        }
    }
}

