/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model.visitors;

import io.sundr.builder.Visitor;
import io.sundr.model.AttributeKey;
import io.sundr.model.ClassRef;
import io.sundr.model.ClassRefBuilder;
import io.sundr.model.MethodFluent;
import io.sundr.model.TypeParamRef;
import io.sundr.model.TypeRef;
import io.sundr.utils.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ApplyTypeParamMappingToMethod
implements Visitor<MethodFluent<?>> {
    private final Map<String, TypeRef> mappings;
    private final Optional<AttributeKey<TypeParamRef>> attributeKey;

    public ApplyTypeParamMappingToMethod(String name, TypeRef typeRef) {
        this(Maps.create((Object)name, (Object)typeRef));
    }

    public ApplyTypeParamMappingToMethod(Map<String, TypeRef> mappings) {
        this(mappings, Optional.empty());
    }

    public ApplyTypeParamMappingToMethod(Map<String, TypeRef> mappings, AttributeKey<TypeParamRef> attributeKey) {
        this(mappings, Optional.ofNullable(attributeKey));
    }

    public ApplyTypeParamMappingToMethod(Map<String, TypeRef> mappings, Optional<AttributeKey<TypeParamRef>> attributeKey) {
        this.mappings = mappings;
        this.attributeKey = attributeKey;
    }

    public void visit(MethodFluent<?> method) {
        ClassRef classRef;
        TypeRef typeRef = method.buildReturnType();
        if (typeRef instanceof TypeParamRef) {
            TypeParamRef typeParamRef = (TypeParamRef)typeRef;
            String key = typeParamRef.getName();
            TypeRef paramRef = this.mappings.get(key);
            if (paramRef != null) {
                method.withReturnType(paramRef);
                this.attributeKey.ifPresent(k -> {
                    MethodFluent cfr_ignored_0 = (MethodFluent)method.addToAttributes(k, (Object)typeParamRef);
                });
            }
        } else if (typeRef instanceof ClassRef && (classRef = (ClassRef)typeRef).getArguments().stream().anyMatch(a -> a instanceof TypeParamRef)) {
            List mappedArguments = classRef.getArguments().stream().map(a -> a instanceof TypeParamRef ? this.mappings.getOrDefault(((TypeParamRef)a).getName(), (TypeRef)a) : a).collect(Collectors.toList());
            method.withReturnType((TypeRef)((ClassRefBuilder)new ClassRefBuilder(classRef).withArguments(mappedArguments)).build());
            this.attributeKey.ifPresent(k -> {
                MethodFluent cfr_ignored_0 = (MethodFluent)method.addToAttributes(k, (Object)classRef);
            });
        }
    }
}

