/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.AttributeKey;
import io.sundr.model.AttributeSupport;
import java.lang.reflect.Modifier;
import java.util.Map;

public class ModifierSupport
extends AttributeSupport {
    public static final String ABSTRACT = "abstract";
    public static final String PUBLIC = "public";
    public static final String PROTECTED = "protected";
    public static final String PRIVATE = "private";
    public static final String STATIC = "static";
    public static final String FINAL = "final";
    public static final String SYNCHRONIZED = "synchronized";
    protected final int modifiers;

    public ModifierSupport(int modifiers, Map<AttributeKey, Object> attributes) {
        super(attributes);
        this.modifiers = modifiers;
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.modifiers);
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.modifiers);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.modifiers);
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.modifiers);
    }

    public boolean isSynchronized() {
        return Modifier.isSynchronized(this.modifiers);
    }

    public boolean isTransient() {
        return Modifier.isTransient(this.modifiers);
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void renderModifiers(StringBuilder sb) {
        if (this.isPublic()) {
            sb.append(PUBLIC).append(" ");
        } else if (this.isProtected()) {
            sb.append(PROTECTED).append(" ");
        } else if (this.isPrivate()) {
            sb.append(PRIVATE).append(" ");
        }
        if (this.isSynchronized()) {
            sb.append(SYNCHRONIZED).append(" ");
        }
        if (this.isStatic()) {
            sb.append(STATIC).append(" ");
        }
        if (this.isAbstract()) {
            sb.append(ABSTRACT).append(" ");
        }
        if (this.isFinal()) {
            sb.append(FINAL).append(" ");
        }
    }

    public String renderModifiers() {
        StringBuilder sb = new StringBuilder();
        this.renderModifiers(sb);
        return sb.toString();
    }
}

