/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.apt.processor;

import io.sundr.adapter.api.AdapterContext;
import io.sundr.adapter.apt.AptContext;
import io.sundr.codegen.api.CodeGenerator;
import io.sundr.codegen.api.Output;
import io.sundr.codegen.apt.TypeDefAptOutput;
import io.sundr.model.TypeDef;
import io.sundr.model.repo.DefinitionRepository;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public abstract class AbstractCodeGeneratingProcessor
extends AbstractProcessor {
    private final AtomicReference<AptContext> context = new AtomicReference();
    protected CodeGenerator generator;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.context.set(AptContext.create((Elements)processingEnv.getElementUtils(), (Types)processingEnv.getTypeUtils(), (DefinitionRepository)DefinitionRepository.createRepository()));
        this.generator = CodeGenerator.newGenerator(TypeDef.class).withOutput((Output)new TypeDefAptOutput(processingEnv.getFiler())).skipping(AbstractCodeGeneratingProcessor::classExists).build();
    }

    public void generate(TypeDef type) {
        if (this.generator == null) {
            throw new IllegalStateException("CodeGenerator instance shoud not be null.");
        }
        this.generator.generate(new Object[]{type});
    }

    public AptContext getAptContext() {
        return this.context.get();
    }

    public AdapterContext getAdapterContext() {
        return this.getAptContext().getAdapterContext();
    }

    public DefinitionRepository getDefinitionRepository() {
        return this.getAdapterContext().getDefinitionRepository();
    }

    private static boolean classExists(TypeDef typeDef) {
        try {
            Class.forName(typeDef.getFullyQualifiedName());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

