/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.client;

import io.strimzi.kafka.oauth.client.ClientConfig;
import io.strimzi.kafka.oauth.client.metrics.ClientAuthenticationSensorKeyProducer;
import io.strimzi.kafka.oauth.client.metrics.ClientHttpSensorKeyProducer;
import io.strimzi.kafka.oauth.common.Config;
import io.strimzi.kafka.oauth.common.ConfigException;
import io.strimzi.kafka.oauth.common.ConfigUtil;
import io.strimzi.kafka.oauth.common.DeprecationUtil;
import io.strimzi.kafka.oauth.common.LogUtil;
import io.strimzi.kafka.oauth.common.MetricsHandler;
import io.strimzi.kafka.oauth.common.OAuthAuthenticator;
import io.strimzi.kafka.oauth.common.PrincipalExtractor;
import io.strimzi.kafka.oauth.common.TokenInfo;
import io.strimzi.kafka.oauth.metrics.SensorKeyProducer;
import io.strimzi.kafka.oauth.services.OAuthMetrics;
import io.strimzi.kafka.oauth.services.Services;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaasClientOauthLoginCallbackHandler
implements AuthenticateCallbackHandler {
    private static final Logger LOG = LoggerFactory.getLogger(JaasClientOauthLoginCallbackHandler.class);
    private ClientConfig config = new ClientConfig();
    private String token;
    private String refreshToken;
    private String clientId;
    private String clientSecret;
    private String username;
    private String password;
    private String scope;
    private String audience;
    private URI tokenEndpoint;
    private boolean isJwt;
    private int maxTokenExpirySeconds;
    private PrincipalExtractor principalExtractor;
    private SSLSocketFactory socketFactory;
    private HostnameVerifier hostnameVerifier;
    private int connectTimeout;
    private int readTimeout;
    private int retries;
    private long retryPauseMillis;
    private boolean enableMetrics;
    private OAuthMetrics metrics;
    private SensorKeyProducer authSensorKeyProducer;
    private SensorKeyProducer tokenSensorKeyProducer;
    private final ClientMetricsHandler authenticatorMetrics = new ClientMetricsHandler();
    private boolean includeAcceptHeader;

    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        if (!"OAUTHBEARER".equals(saslMechanism)) {
            throw new IllegalArgumentException("Unexpected SASL mechanism: " + saslMechanism);
        }
        for (AppConfigurationEntry e : jaasConfigEntries) {
            Properties p = new Properties();
            p.putAll(e.getOptions());
            this.config = new ClientConfig(p);
        }
        this.token = this.config.getValue("oauth.access.token");
        if (this.token == null) {
            String endpoint = this.config.getValue("oauth.token.endpoint.uri");
            if (endpoint == null) {
                throw new ConfigException("Access token not specified ('oauth.access.token'). OAuth token endpoint ('oauth.token.endpoint.uri') should then be set.");
            }
            try {
                this.tokenEndpoint = new URI(endpoint);
            }
            catch (URISyntaxException e) {
                throw new ConfigException("Specified token endpoint uri is invalid ('oauth.token.endpoint.uri'): " + endpoint, (Throwable)e);
            }
        }
        this.refreshToken = this.config.getValue("oauth.refresh.token");
        this.clientId = this.config.getValue("oauth.client.id");
        this.clientSecret = this.config.getValue("oauth.client.secret");
        this.username = this.config.getValue("oauth.password.grant.username");
        this.password = this.config.getValue("oauth.password.grant.password");
        this.scope = this.config.getValue("oauth.scope");
        this.audience = this.config.getValue("oauth.audience");
        this.socketFactory = ConfigUtil.createSSLFactory((Config)this.config);
        this.hostnameVerifier = ConfigUtil.createHostnameVerifier((Config)this.config);
        this.connectTimeout = ConfigUtil.getConnectTimeout((Config)this.config);
        this.readTimeout = ConfigUtil.getReadTimeout((Config)this.config);
        this.retries = this.getHttpRetries(this.config);
        this.retryPauseMillis = this.getHttpRetryPauseMillis(this.config, this.retries);
        this.includeAcceptHeader = this.config.getValueAsBoolean("oauth.include.accept.header", true);
        this.checkConfiguration();
        this.principalExtractor = new PrincipalExtractor(this.config.getValue("oauth.username.claim"), this.config.getValue("oauth.fallback.username.claim"), this.config.getValue("oauth.fallback.username.prefix"));
        this.isJwt = DeprecationUtil.isAccessTokenJwt((Config)this.config, (Logger)LOG, null);
        if (!this.isJwt && this.principalExtractor.isConfigured()) {
            LOG.warn("Token is not JWT ('{}' is 'false') - custom username claim configuration will be ignored ('{}', '{}', '{}')", new Object[]{"oauth.access.token.is.jwt", "oauth.username.claim", "oauth.fallback.username.claim", "oauth.fallback.username.prefix"});
        }
        this.maxTokenExpirySeconds = this.config.getValueAsInt("oauth.max.token.expiry.seconds", -1);
        if (this.maxTokenExpirySeconds > 0 && this.maxTokenExpirySeconds < 60) {
            throw new ConfigException("Invalid value configured for 'oauth.max.token.expiry.seconds': " + this.maxTokenExpirySeconds + " (should be at least 60)");
        }
        String configId = this.configureMetrics(configs);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Configured JaasClientOauthLoginCallbackHandler:\n    configId: " + configId + "\n    token: " + LogUtil.mask((String)this.token) + "\n    refreshToken: " + LogUtil.mask((String)this.refreshToken) + "\n    tokenEndpointUri: " + this.tokenEndpoint + "\n    clientId: " + this.clientId + "\n    clientSecret: " + LogUtil.mask((String)this.clientSecret) + "\n    username: " + this.username + "\n    password: " + LogUtil.mask((String)this.password) + "\n    scope: " + this.scope + "\n    audience: " + this.audience + "\n    isJwt: " + this.isJwt + "\n    maxTokenExpirySeconds: " + this.maxTokenExpirySeconds + "\n    principalExtractor: " + this.principalExtractor + "\n    connectTimeout: " + this.connectTimeout + "\n    readTimeout: " + this.readTimeout + "\n    retries: " + this.retries + "\n    retryPauseMillis: " + this.retryPauseMillis + "\n    enableMetrics: " + this.enableMetrics + "\n    includeAcceptHeader: " + this.includeAcceptHeader);
        }
    }

    private int getHttpRetries(ClientConfig config) {
        int retries = config.getValueAsInt("oauth.http.retries", 0);
        if (retries < 0) {
            throw new ConfigException("The configured value of 'oauth.http.retries' has to be greater or equal to zero");
        }
        return retries;
    }

    private long getHttpRetryPauseMillis(ClientConfig config, int retries) {
        long retryPauseMillis = config.getValueAsLong("oauth.http.retry.pause.millis", 0L);
        if (retries > 0) {
            if (retryPauseMillis < 0L) {
                retryPauseMillis = 0L;
                LOG.warn("The configured value of '{}' is less than zero and will be ignored", (Object)"oauth.http.retry.pause.millis");
            }
            if (retryPauseMillis <= 0L) {
                LOG.warn("No pause between http retries configured. Consider setting '{}' to greater than zero to avoid flooding the authorization server with requests.", (Object)"oauth.http.retry.pause.millis");
            }
        }
        return retryPauseMillis;
    }

    private void checkConfiguration() {
        if (this.token != null) {
            if (this.refreshToken != null) {
                LOG.warn("Access token is configured ('{}'), refresh token will be ignored ('{}').", (Object)"oauth.access.token", (Object)"oauth.refresh.token");
            }
            if (this.username != null) {
                LOG.warn("Access token is configured ('{}'), username will be ignored ('{}').", (Object)"oauth.access.token", (Object)"oauth.password.grant.username");
            }
            if (this.clientId != null) {
                LOG.warn("Access token is configured ('{}'), client id will be ignored ('{}').", (Object)"oauth.access.token", (Object)"oauth.client.id");
            }
        } else if (this.refreshToken != null && this.username != null) {
            LOG.warn("Refresh token is configured ('{}'), username will be ignored ('{}').", (Object)"oauth.refresh.token", (Object)"oauth.password.grant.username");
        }
        if (this.token == null) {
            if (this.clientId == null) {
                throw new ConfigException("No client id specified ('oauth.client.id')");
            }
            if (this.username != null && this.password == null) {
                throw new ConfigException("Username configured ('oauth.password.grant.username') but no password specified ('oauth.password.grant.password')");
            }
            if (this.refreshToken == null && this.clientSecret == null && this.username == null) {
                throw new ConfigException("No access token ('oauth.access.token'), refresh token ('oauth.refresh.token'), client credentials ('oauth.client.secret') or user credentials specified ('oauth.password.grant.username')");
            }
        }
    }

    private String configureMetrics(Map<String, ?> configs) {
        String configId = this.config.getValue("oauth.config.id", "client");
        this.enableMetrics = this.config.getValueAsBoolean("oauth.enable.metrics", false);
        this.authSensorKeyProducer = new ClientAuthenticationSensorKeyProducer(configId, this.tokenEndpoint);
        ClientHttpSensorKeyProducer clientHttpSensorKeyProducer = this.tokenSensorKeyProducer = this.tokenEndpoint != null ? new ClientHttpSensorKeyProducer(configId, this.tokenEndpoint) : null;
        if (!Services.isAvailable()) {
            Services.configure(configs);
        }
        if (this.enableMetrics) {
            this.metrics = Services.getInstance().getMetrics();
        }
        return configId;
    }

    public void close() {
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (!(callback instanceof OAuthBearerTokenCallback)) {
                throw new UnsupportedCallbackException(callback);
            }
            this.handleCallback((OAuthBearerTokenCallback)callback);
        }
    }

    private void handleCallback(OAuthBearerTokenCallback callback) throws IOException {
        TokenInfo result;
        if (callback.token() != null) {
            throw new IllegalArgumentException("Callback had a token already");
        }
        long requestStartTime = System.currentTimeMillis();
        try {
            if (this.token != null) {
                result = OAuthAuthenticator.loginWithAccessToken((String)this.token, (boolean)this.isJwt, (PrincipalExtractor)this.principalExtractor);
            } else if (this.refreshToken != null) {
                result = OAuthAuthenticator.loginWithRefreshToken((URI)this.tokenEndpoint, (SSLSocketFactory)this.socketFactory, (HostnameVerifier)this.hostnameVerifier, (String)this.refreshToken, (String)this.clientId, (String)this.clientSecret, (boolean)this.isJwt, (PrincipalExtractor)this.principalExtractor, (String)this.scope, (String)this.audience, (int)this.connectTimeout, (int)this.readTimeout, (MetricsHandler)this.authenticatorMetrics, (int)this.retries, (long)this.retryPauseMillis, (boolean)this.includeAcceptHeader);
            } else if (this.username != null) {
                result = OAuthAuthenticator.loginWithPassword((URI)this.tokenEndpoint, (SSLSocketFactory)this.socketFactory, (HostnameVerifier)this.hostnameVerifier, (String)this.username, (String)this.password, (String)this.clientId, (String)this.clientSecret, (boolean)this.isJwt, (PrincipalExtractor)this.principalExtractor, (String)this.scope, (String)this.audience, (int)this.connectTimeout, (int)this.readTimeout, (MetricsHandler)this.authenticatorMetrics, (int)this.retries, (long)this.retryPauseMillis, (boolean)this.includeAcceptHeader);
            } else if (this.clientSecret != null) {
                result = OAuthAuthenticator.loginWithClientSecret((URI)this.tokenEndpoint, (SSLSocketFactory)this.socketFactory, (HostnameVerifier)this.hostnameVerifier, (String)this.clientId, (String)this.clientSecret, (boolean)this.isJwt, (PrincipalExtractor)this.principalExtractor, (String)this.scope, (String)this.audience, (int)this.connectTimeout, (int)this.readTimeout, (MetricsHandler)this.authenticatorMetrics, (int)this.retries, (long)this.retryPauseMillis, (boolean)this.includeAcceptHeader);
            } else {
                throw new IllegalStateException("Invalid oauth client configuration - no credentials");
            }
            this.addSuccessTime(requestStartTime);
        }
        catch (Throwable t) {
            this.addErrorTime(t, requestStartTime);
            throw t;
        }
        final TokenInfo finalResult = result;
        callback.token(new OAuthBearerToken(){

            public String value() {
                return finalResult.token();
            }

            public Set<String> scope() {
                return finalResult.scope();
            }

            public long lifetimeMs() {
                long maxExpiresAt = finalResult.issuedAtMs() + (long)JaasClientOauthLoginCallbackHandler.this.maxTokenExpirySeconds * 1000L;
                if (JaasClientOauthLoginCallbackHandler.this.maxTokenExpirySeconds > 0 && finalResult.expiresAtMs() > maxExpiresAt) {
                    return maxExpiresAt;
                }
                return finalResult.expiresAtMs();
            }

            public String principalName() {
                return finalResult.principal();
            }

            public Long startTimeMs() {
                return finalResult.issuedAtMs();
            }
        });
    }

    private void addSuccessTime(long startTimeMs) {
        if (this.enableMetrics) {
            this.metrics.addTime(this.authSensorKeyProducer.successKey(), System.currentTimeMillis() - startTimeMs);
        }
    }

    private void addErrorTime(Throwable e, long startTimeMs) {
        if (this.enableMetrics) {
            this.metrics.addTime(this.authSensorKeyProducer.errorKey(e), System.currentTimeMillis() - startTimeMs);
        }
    }

    class ClientMetricsHandler
    implements MetricsHandler {
        ClientMetricsHandler() {
        }

        public void addSuccessRequestTime(long millis) {
            if (JaasClientOauthLoginCallbackHandler.this.enableMetrics) {
                JaasClientOauthLoginCallbackHandler.this.metrics.addTime(JaasClientOauthLoginCallbackHandler.this.tokenSensorKeyProducer.successKey(), millis);
            }
        }

        public void addErrorRequestTime(Throwable e, long millis) {
            if (JaasClientOauthLoginCallbackHandler.this.enableMetrics) {
                JaasClientOauthLoginCallbackHandler.this.metrics.addTime(JaasClientOauthLoginCallbackHandler.this.tokenSensorKeyProducer.errorKey(e), millis);
            }
        }
    }
}

