/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.template.InternalServiceTemplate;
import io.strimzi.api.kafka.model.template.InternalServiceTemplateFluent;
import io.strimzi.api.kafka.model.template.IpFamily;
import io.strimzi.api.kafka.model.template.IpFamilyPolicy;
import io.strimzi.api.kafka.model.template.MetadataTemplate;
import io.strimzi.api.kafka.model.template.MetadataTemplateBuilder;
import io.strimzi.api.kafka.model.template.MetadataTemplateFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class InternalServiceTemplateFluentImpl<A extends InternalServiceTemplateFluent<A>>
extends BaseFluent<A>
implements InternalServiceTemplateFluent<A> {
    private MetadataTemplateBuilder metadata;
    private IpFamilyPolicy ipFamilyPolicy;
    private List<IpFamily> ipFamilies;

    public InternalServiceTemplateFluentImpl() {
    }

    public InternalServiceTemplateFluentImpl(InternalServiceTemplate instance) {
        this.withMetadata(instance.getMetadata());
        this.withIpFamilyPolicy(instance.getIpFamilyPolicy());
        this.withIpFamilies(instance.getIpFamilies());
    }

    @Override
    @Deprecated
    public MetadataTemplate getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public MetadataTemplate buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(MetadataTemplate metadata) {
        this._visitables.get((Object)"metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new MetadataTemplateBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public InternalServiceTemplateFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public InternalServiceTemplateFluent.MetadataNested<A> withNewMetadataLike(MetadataTemplate item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public InternalServiceTemplateFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public InternalServiceTemplateFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new MetadataTemplateBuilder().build());
    }

    @Override
    public InternalServiceTemplateFluent.MetadataNested<A> editOrNewMetadataLike(MetadataTemplate item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public IpFamilyPolicy getIpFamilyPolicy() {
        return this.ipFamilyPolicy;
    }

    @Override
    public A withIpFamilyPolicy(IpFamilyPolicy ipFamilyPolicy) {
        this.ipFamilyPolicy = ipFamilyPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasIpFamilyPolicy() {
        return this.ipFamilyPolicy != null;
    }

    @Override
    public A addToIpFamilies(int index, IpFamily item) {
        if (this.ipFamilies == null) {
            this.ipFamilies = new ArrayList<IpFamily>();
        }
        this.ipFamilies.add(index, item);
        return (A)this;
    }

    @Override
    public A setToIpFamilies(int index, IpFamily item) {
        if (this.ipFamilies == null) {
            this.ipFamilies = new ArrayList<IpFamily>();
        }
        this.ipFamilies.set(index, item);
        return (A)this;
    }

    @Override
    public A addToIpFamilies(IpFamily ... items) {
        if (this.ipFamilies == null) {
            this.ipFamilies = new ArrayList<IpFamily>();
        }
        for (IpFamily item : items) {
            this.ipFamilies.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToIpFamilies(Collection<IpFamily> items) {
        if (this.ipFamilies == null) {
            this.ipFamilies = new ArrayList<IpFamily>();
        }
        for (IpFamily item : items) {
            this.ipFamilies.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromIpFamilies(IpFamily ... items) {
        for (IpFamily item : items) {
            if (this.ipFamilies == null) continue;
            this.ipFamilies.remove((Object)item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromIpFamilies(Collection<IpFamily> items) {
        for (IpFamily item : items) {
            if (this.ipFamilies == null) continue;
            this.ipFamilies.remove((Object)item);
        }
        return (A)this;
    }

    @Override
    public List<IpFamily> getIpFamilies() {
        return this.ipFamilies;
    }

    @Override
    public IpFamily getIpFamily(int index) {
        return this.ipFamilies.get(index);
    }

    @Override
    public IpFamily getFirstIpFamily() {
        return this.ipFamilies.get(0);
    }

    @Override
    public IpFamily getLastIpFamily() {
        return this.ipFamilies.get(this.ipFamilies.size() - 1);
    }

    @Override
    public IpFamily getMatchingIpFamily(Predicate<IpFamily> predicate) {
        for (IpFamily item : this.ipFamilies) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingIpFamily(Predicate<IpFamily> predicate) {
        for (IpFamily item : this.ipFamilies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withIpFamilies(List<IpFamily> ipFamilies) {
        if (this.ipFamilies != null) {
            this._visitables.get((Object)"ipFamilies").removeAll(this.ipFamilies);
        }
        if (ipFamilies != null) {
            this.ipFamilies = new ArrayList<IpFamily>();
            for (IpFamily item : ipFamilies) {
                this.addToIpFamilies(item);
            }
        } else {
            this.ipFamilies = null;
        }
        return (A)this;
    }

    @Override
    public A withIpFamilies(IpFamily ... ipFamilies) {
        if (this.ipFamilies != null) {
            this.ipFamilies.clear();
        }
        if (ipFamilies != null) {
            for (IpFamily item : ipFamilies) {
                this.addToIpFamilies(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasIpFamilies() {
        return this.ipFamilies != null && !this.ipFamilies.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalServiceTemplateFluentImpl that = (InternalServiceTemplateFluentImpl)o;
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.ipFamilyPolicy != null ? !this.ipFamilyPolicy.equals((Object)that.ipFamilyPolicy) : that.ipFamilyPolicy != null) {
            return false;
        }
        return !(this.ipFamilies != null ? !this.ipFamilies.equals(that.ipFamilies) : that.ipFamilies != null);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.metadata, this.ipFamilyPolicy, this.ipFamilies, super.hashCode()});
    }

    public class MetadataNestedImpl<N>
    extends MetadataTemplateFluentImpl<InternalServiceTemplateFluent.MetadataNested<N>>
    implements InternalServiceTemplateFluent.MetadataNested<N>,
    Nested<N> {
        private final MetadataTemplateBuilder builder;

        MetadataNestedImpl(MetadataTemplate item) {
            this.builder = new MetadataTemplateBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new MetadataTemplateBuilder(this);
        }

        @Override
        public N and() {
            return (N)InternalServiceTemplateFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

