/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.status;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.UnknownPropertyPreserving;
import io.strimzi.api.kafka.model.status.ListenerAddress;
import io.strimzi.crdgenerator.annotations.Description;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "name", "addresses", "bootstrapServers", "certificates"})
public class ListenerStatus
implements UnknownPropertyPreserving,
Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private List<ListenerAddress> addresses;
    private String bootstrapServers;
    private List<String> certificates;
    private Map<String, Object> additionalProperties;

    @Description(value="*The `type` property has been deprecated, and should now be configured using `name`.* The name of the listener.")
    public String getType() {
        return this.name;
    }

    @Deprecated
    public void setType(String name) {
        this.name = name;
    }

    @Description(value="The name of the listener.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Description(value="A list of the addresses for this listener.")
    public List<ListenerAddress> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<ListenerAddress> addresses) {
        this.addresses = addresses;
        this.bootstrapServers = addresses == null || addresses.isEmpty() ? null : addresses.stream().map(a -> a.getHost() + ":" + a.getPort()).distinct().collect(Collectors.joining(","));
    }

    @Description(value="A comma-separated list of `host:port` pairs for connecting to the Kafka cluster using this listener.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    @Description(value="A list of TLS certificates which can be used to verify the identity of the server when connecting to the given listener. Set only for `tls` and `external` listeners.")
    public List<String> getCertificates() {
        return this.certificates;
    }

    public void setCertificates(List<String> certificates) {
        this.certificates = certificates;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties != null ? this.additionalProperties : Collections.emptyMap();
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>(1);
        }
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListenerStatus)) {
            return false;
        }
        ListenerStatus other = (ListenerStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<ListenerAddress> this$addresses = this.getAddresses();
        List<ListenerAddress> other$addresses = other.getAddresses();
        if (this$addresses == null ? other$addresses != null : !((Object)this$addresses).equals(other$addresses)) {
            return false;
        }
        String this$bootstrapServers = this.getBootstrapServers();
        String other$bootstrapServers = other.getBootstrapServers();
        if (this$bootstrapServers == null ? other$bootstrapServers != null : !this$bootstrapServers.equals(other$bootstrapServers)) {
            return false;
        }
        List<String> this$certificates = this.getCertificates();
        List<String> other$certificates = other.getCertificates();
        if (this$certificates == null ? other$certificates != null : !((Object)this$certificates).equals(other$certificates)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListenerStatus;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<ListenerAddress> $addresses = this.getAddresses();
        result = result * 59 + ($addresses == null ? 43 : ((Object)$addresses).hashCode());
        String $bootstrapServers = this.getBootstrapServers();
        result = result * 59 + ($bootstrapServers == null ? 43 : $bootstrapServers.hashCode());
        List<String> $certificates = this.getCertificates();
        result = result * 59 + ($certificates == null ? 43 : ((Object)$certificates).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

