/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.status.KafkaTopicStatus;
import io.strimzi.api.kafka.model.status.KafkaTopicStatusFluent;
import io.strimzi.api.kafka.model.status.KafkaTopicStatusFluentImpl;
import java.util.Objects;

public class KafkaTopicStatusBuilder
extends KafkaTopicStatusFluentImpl<KafkaTopicStatusBuilder>
implements VisitableBuilder<KafkaTopicStatus, KafkaTopicStatusBuilder> {
    KafkaTopicStatusFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaTopicStatusBuilder() {
        this(true);
    }

    public KafkaTopicStatusBuilder(Boolean validationEnabled) {
        this(new KafkaTopicStatus(), validationEnabled);
    }

    public KafkaTopicStatusBuilder(KafkaTopicStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public KafkaTopicStatusBuilder(KafkaTopicStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KafkaTopicStatus(), validationEnabled);
    }

    public KafkaTopicStatusBuilder(KafkaTopicStatusFluent<?> fluent, KafkaTopicStatus instance) {
        this(fluent, instance, true);
    }

    public KafkaTopicStatusBuilder(KafkaTopicStatusFluent<?> fluent, KafkaTopicStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withTopicName(instance.getTopicName());
        fluent.withConditions(instance.getConditions());
        fluent.withObservedGeneration(instance.getObservedGeneration());
        this.validationEnabled = validationEnabled;
    }

    public KafkaTopicStatusBuilder(KafkaTopicStatus instance) {
        this(instance, (Boolean)true);
    }

    public KafkaTopicStatusBuilder(KafkaTopicStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withTopicName(instance.getTopicName());
        this.withConditions(instance.getConditions());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.validationEnabled = validationEnabled;
    }

    public KafkaTopicStatus build() {
        KafkaTopicStatus buildable = new KafkaTopicStatus();
        buildable.setConditions(this.fluent.getConditions());
        buildable.setObservedGeneration(this.fluent.getObservedGeneration());
        buildable.setTopicName(this.fluent.getTopicName());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaTopicStatusBuilder that = (KafkaTopicStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

