/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.connect.build.JarArtifact;
import io.strimzi.api.kafka.model.connect.build.JarArtifactFluent;
import io.strimzi.api.kafka.model.connect.build.JarArtifactFluentImpl;
import java.util.Objects;

public class JarArtifactBuilder
extends JarArtifactFluentImpl<JarArtifactBuilder>
implements VisitableBuilder<JarArtifact, JarArtifactBuilder> {
    JarArtifactFluent<?> fluent;
    Boolean validationEnabled;

    public JarArtifactBuilder() {
        this(true);
    }

    public JarArtifactBuilder(Boolean validationEnabled) {
        this(new JarArtifact(), validationEnabled);
    }

    public JarArtifactBuilder(JarArtifactFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public JarArtifactBuilder(JarArtifactFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new JarArtifact(), validationEnabled);
    }

    public JarArtifactBuilder(JarArtifactFluent<?> fluent, JarArtifact instance) {
        this(fluent, instance, true);
    }

    public JarArtifactBuilder(JarArtifactFluent<?> fluent, JarArtifact instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withUrl(instance.getUrl());
        fluent.withSha512sum(instance.getSha512sum());
        fluent.withInsecure(instance.getInsecure());
        this.validationEnabled = validationEnabled;
    }

    public JarArtifactBuilder(JarArtifact instance) {
        this(instance, (Boolean)true);
    }

    public JarArtifactBuilder(JarArtifact instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withUrl(instance.getUrl());
        this.withSha512sum(instance.getSha512sum());
        this.withInsecure(instance.getInsecure());
        this.validationEnabled = validationEnabled;
    }

    public JarArtifact build() {
        JarArtifact buildable = new JarArtifact();
        buildable.setUrl(this.fluent.getUrl());
        buildable.setSha512sum(this.fluent.getSha512sum());
        buildable.setInsecure(this.fluent.getInsecure());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JarArtifactBuilder that = (JarArtifactBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

