/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.KafkaUserQuotas;
import io.strimzi.api.kafka.model.KafkaUserQuotasFluent;
import io.strimzi.api.kafka.model.KafkaUserQuotasFluentImpl;
import java.util.Objects;

public class KafkaUserQuotasBuilder
extends KafkaUserQuotasFluentImpl<KafkaUserQuotasBuilder>
implements VisitableBuilder<KafkaUserQuotas, KafkaUserQuotasBuilder> {
    KafkaUserQuotasFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaUserQuotasBuilder() {
        this(true);
    }

    public KafkaUserQuotasBuilder(Boolean validationEnabled) {
        this(new KafkaUserQuotas(), validationEnabled);
    }

    public KafkaUserQuotasBuilder(KafkaUserQuotasFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public KafkaUserQuotasBuilder(KafkaUserQuotasFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KafkaUserQuotas(), validationEnabled);
    }

    public KafkaUserQuotasBuilder(KafkaUserQuotasFluent<?> fluent, KafkaUserQuotas instance) {
        this(fluent, instance, true);
    }

    public KafkaUserQuotasBuilder(KafkaUserQuotasFluent<?> fluent, KafkaUserQuotas instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withProducerByteRate(instance.getProducerByteRate());
        fluent.withConsumerByteRate(instance.getConsumerByteRate());
        fluent.withRequestPercentage(instance.getRequestPercentage());
        fluent.withControllerMutationRate(instance.getControllerMutationRate());
        this.validationEnabled = validationEnabled;
    }

    public KafkaUserQuotasBuilder(KafkaUserQuotas instance) {
        this(instance, (Boolean)true);
    }

    public KafkaUserQuotasBuilder(KafkaUserQuotas instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withProducerByteRate(instance.getProducerByteRate());
        this.withConsumerByteRate(instance.getConsumerByteRate());
        this.withRequestPercentage(instance.getRequestPercentage());
        this.withControllerMutationRate(instance.getControllerMutationRate());
        this.validationEnabled = validationEnabled;
    }

    public KafkaUserQuotas build() {
        KafkaUserQuotas buildable = new KafkaUserQuotas();
        buildable.setProducerByteRate(this.fluent.getProducerByteRate());
        buildable.setConsumerByteRate(this.fluent.getConsumerByteRate());
        buildable.setRequestPercentage(this.fluent.getRequestPercentage());
        buildable.setControllerMutationRate(this.fluent.getControllerMutationRate());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaUserQuotasBuilder that = (KafkaUserQuotasBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

