/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.KafkaConnect;
import io.strimzi.api.kafka.model.KafkaConnectFluent;
import io.strimzi.api.kafka.model.KafkaConnectFluentImpl;
import java.util.Objects;

public class KafkaConnectBuilder
extends KafkaConnectFluentImpl<KafkaConnectBuilder>
implements VisitableBuilder<KafkaConnect, KafkaConnectBuilder> {
    KafkaConnectFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaConnectBuilder() {
        this(true);
    }

    public KafkaConnectBuilder(Boolean validationEnabled) {
        this(new KafkaConnect(), validationEnabled);
    }

    public KafkaConnectBuilder(KafkaConnectFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public KafkaConnectBuilder(KafkaConnectFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KafkaConnect(), validationEnabled);
    }

    public KafkaConnectBuilder(KafkaConnectFluent<?> fluent, KafkaConnect instance) {
        this(fluent, instance, true);
    }

    public KafkaConnectBuilder(KafkaConnectFluent<?> fluent, KafkaConnect instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withSpec(instance.getSpec());
        fluent.withMetadata(instance.getMetadata());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public KafkaConnectBuilder(KafkaConnect instance) {
        this(instance, (Boolean)true);
    }

    public KafkaConnectBuilder(KafkaConnect instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withSpec(instance.getSpec());
        this.withMetadata(instance.getMetadata());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public KafkaConnect build() {
        KafkaConnect buildable = new KafkaConnect();
        buildable.setApiVersion(this.fluent.getApiVersion());
        buildable.setKind(this.fluent.getKind());
        buildable.setSpec(this.fluent.getSpec());
        buildable.setMetadata(this.fluent.getMetadata());
        buildable.setStatus(this.fluent.getStatus());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaConnectBuilder that = (KafkaConnectBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

