/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.KafkaClusterSpec;
import io.strimzi.api.kafka.model.KafkaClusterSpecFluent;
import io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl;
import java.util.Objects;

public class KafkaClusterSpecBuilder
extends KafkaClusterSpecFluentImpl<KafkaClusterSpecBuilder>
implements VisitableBuilder<KafkaClusterSpec, KafkaClusterSpecBuilder> {
    KafkaClusterSpecFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaClusterSpecBuilder() {
        this(true);
    }

    public KafkaClusterSpecBuilder(Boolean validationEnabled) {
        this(new KafkaClusterSpec(), validationEnabled);
    }

    public KafkaClusterSpecBuilder(KafkaClusterSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public KafkaClusterSpecBuilder(KafkaClusterSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KafkaClusterSpec(), validationEnabled);
    }

    public KafkaClusterSpecBuilder(KafkaClusterSpecFluent<?> fluent, KafkaClusterSpec instance) {
        this(fluent, instance, true);
    }

    public KafkaClusterSpecBuilder(KafkaClusterSpecFluent<?> fluent, KafkaClusterSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withStorage(instance.getStorage());
        fluent.withVersion(instance.getVersion());
        fluent.withConfig(instance.getConfig());
        fluent.withBrokerRackInitImage(instance.getBrokerRackInitImage());
        fluent.withRack(instance.getRack());
        fluent.withLogging(instance.getLogging());
        fluent.withReplicas(instance.getReplicas());
        fluent.withImage(instance.getImage());
        fluent.withResources(instance.getResources());
        fluent.withLivenessProbe(instance.getLivenessProbe());
        fluent.withReadinessProbe(instance.getReadinessProbe());
        fluent.withJvmOptions(instance.getJvmOptions());
        fluent.withJmxOptions(instance.getJmxOptions());
        fluent.withMetricsConfig(instance.getMetricsConfig());
        fluent.withListeners(instance.getListeners());
        fluent.withAuthorization(instance.getAuthorization());
        fluent.withTemplate(instance.getTemplate());
        this.validationEnabled = validationEnabled;
    }

    public KafkaClusterSpecBuilder(KafkaClusterSpec instance) {
        this(instance, (Boolean)true);
    }

    public KafkaClusterSpecBuilder(KafkaClusterSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withStorage(instance.getStorage());
        this.withVersion(instance.getVersion());
        this.withConfig(instance.getConfig());
        this.withBrokerRackInitImage(instance.getBrokerRackInitImage());
        this.withRack(instance.getRack());
        this.withLogging(instance.getLogging());
        this.withReplicas(instance.getReplicas());
        this.withImage(instance.getImage());
        this.withResources(instance.getResources());
        this.withLivenessProbe(instance.getLivenessProbe());
        this.withReadinessProbe(instance.getReadinessProbe());
        this.withJvmOptions(instance.getJvmOptions());
        this.withJmxOptions(instance.getJmxOptions());
        this.withMetricsConfig(instance.getMetricsConfig());
        this.withListeners(instance.getListeners());
        this.withAuthorization(instance.getAuthorization());
        this.withTemplate(instance.getTemplate());
        this.validationEnabled = validationEnabled;
    }

    public KafkaClusterSpec build() {
        KafkaClusterSpec buildable = new KafkaClusterSpec();
        buildable.setStorage(this.fluent.getStorage());
        buildable.setVersion(this.fluent.getVersion());
        buildable.setConfig(this.fluent.getConfig());
        buildable.setBrokerRackInitImage(this.fluent.getBrokerRackInitImage());
        buildable.setRack(this.fluent.getRack());
        buildable.setLogging(this.fluent.getLogging());
        buildable.setReplicas(this.fluent.getReplicas());
        buildable.setImage(this.fluent.getImage());
        buildable.setResources(this.fluent.getResources());
        buildable.setLivenessProbe(this.fluent.getLivenessProbe());
        buildable.setReadinessProbe(this.fluent.getReadinessProbe());
        buildable.setJvmOptions(this.fluent.getJvmOptions());
        buildable.setJmxOptions(this.fluent.getJmxOptions());
        buildable.setMetricsConfig(this.fluent.getMetricsConfig());
        buildable.setListeners(this.fluent.getListeners());
        buildable.setAuthorization(this.fluent.getAuthorization());
        buildable.setTemplate(this.fluent.getTemplate());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaClusterSpecBuilder that = (KafkaClusterSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

