/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.pulsar.client.api.ConsumerCryptoFailureAction;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.TableView;
import org.apache.pulsar.client.api.TableViewBuilder;
import org.apache.pulsar.client.impl.DefaultCryptoKeyReader;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.TableViewConfigurationData;
import org.apache.pulsar.client.impl.TableViewImpl;
import org.apache.pulsar.client.impl.conf.ConfigurationDataUtils;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;

public class TableViewBuilderImpl<T>
implements TableViewBuilder<T> {
    private final PulsarClientImpl client;
    private final Schema<T> schema;
    private TableViewConfigurationData conf;

    TableViewBuilderImpl(PulsarClientImpl client, Schema<T> schema) {
        this.client = client;
        this.schema = schema;
        this.conf = new TableViewConfigurationData();
    }

    @Override
    public TableViewBuilder<T> loadConf(Map<String, Object> config) {
        this.conf = ConfigurationDataUtils.loadData(config, this.conf, TableViewConfigurationData.class);
        return this;
    }

    @Override
    public TableView<T> create() throws PulsarClientException {
        try {
            return this.createAsync().get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap(e);
        }
    }

    @Override
    public CompletableFuture<TableView<T>> createAsync() {
        return new TableViewImpl<T>(this.client, this.schema, this.conf).start();
    }

    @Override
    public TableViewBuilder<T> topic(String topic) {
        Preconditions.checkArgument(StringUtils.isNotBlank(topic), "topic cannot be blank");
        this.conf.setTopicName(StringUtils.trim(topic));
        return this;
    }

    @Override
    public TableViewBuilder<T> autoUpdatePartitionsInterval(int interval, TimeUnit unit) {
        Preconditions.checkArgument(unit.toSeconds(interval) >= 1L, "minimum is 1 second");
        this.conf.setAutoUpdatePartitionsSeconds(unit.toSeconds(interval));
        return this;
    }

    @Override
    public TableViewBuilder<T> subscriptionName(String subscriptionName) {
        Preconditions.checkArgument(StringUtils.isNotBlank(subscriptionName), "subscription name cannot be blank");
        this.conf.setSubscriptionName(StringUtils.trim(subscriptionName));
        return this;
    }

    @Override
    public TableViewBuilder<T> cryptoKeyReader(CryptoKeyReader cryptoKeyReader) {
        this.conf.setCryptoKeyReader(cryptoKeyReader);
        return this;
    }

    @Override
    public TableViewBuilder<T> defaultCryptoKeyReader(String privateKey) {
        Preconditions.checkArgument(StringUtils.isNotBlank(privateKey), "privateKey cannot be blank");
        return this.cryptoKeyReader(DefaultCryptoKeyReader.builder().defaultPrivateKey(privateKey).build());
    }

    @Override
    public TableViewBuilder<T> defaultCryptoKeyReader(@NonNull Map<String, String> privateKeys) {
        if (privateKeys == null) {
            throw new NullPointerException("privateKeys is marked non-null but is null");
        }
        Preconditions.checkArgument(!privateKeys.isEmpty(), "privateKeys cannot be empty");
        return this.cryptoKeyReader(DefaultCryptoKeyReader.builder().privateKeys(privateKeys).build());
    }

    @Override
    public TableViewBuilder<T> cryptoFailureAction(ConsumerCryptoFailureAction action) {
        this.conf.setCryptoFailureAction(action);
        return this;
    }
}

