/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import io.swagger.models.auth.SecuritySchemeDefinition;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mapstruct.Mapper;
import springfox.documentation.service.ResourceListing;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.swagger2.mappers.ApiKeyAuthFactory;
import springfox.documentation.swagger2.mappers.BasicAuthFactory;
import springfox.documentation.swagger2.mappers.HttpAuthenticationSchemeFactory;
import springfox.documentation.swagger2.mappers.OAuth2AuthFactory;
import springfox.documentation.swagger2.mappers.OpenIdConnectSchemeFactory;
import springfox.documentation.swagger2.mappers.SecuritySchemeFactory;

@Mapper(componentModel="spring")
public class SecurityMapper {
    private Map<String, SecuritySchemeFactory> factories = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<String, OAuth2AuthFactory>("oauth2", new OAuth2AuthFactory()), new AbstractMap.SimpleEntry<String, ApiKeyAuthFactory>("apiKey", new ApiKeyAuthFactory()), new AbstractMap.SimpleEntry<String, BasicAuthFactory>("basicAuth", new BasicAuthFactory()), new AbstractMap.SimpleEntry<String, HttpAuthenticationSchemeFactory>("http", new HttpAuthenticationSchemeFactory()), new AbstractMap.SimpleEntry<String, OpenIdConnectSchemeFactory>("openIdConnect", new OpenIdConnectSchemeFactory())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));

    public Map<String, SecuritySchemeDefinition> toSecuritySchemeDefinitions(ResourceListing from) {
        if (from == null) {
            return new HashMap<String, SecuritySchemeDefinition>();
        }
        TreeMap<String, SecuritySchemeDefinition> result = new TreeMap<String, SecuritySchemeDefinition>(from.getSecuritySchemes().stream().collect(Collectors.toMap(SecurityScheme::getName, this.toSecuritySchemeDefinition())));
        return result;
    }

    private Function<SecurityScheme, SecuritySchemeDefinition> toSecuritySchemeDefinition() {
        return input -> this.factories.get(input.getType()).create((SecurityScheme)input);
    }
}

